
//////////////////////////////////////////////////////////////////////////////////
// document utilities
//////////////////////////////////////////////////////////////////////////////////

function moveDivTo(div,left,top){
  if(document.layers){ div.moveTo(left,top); return; } 
  if(typeof(div.style.left)!="undefined"&& typeof(div.style.left)=="string"){ 
    div.style.left=left+'px';
    div.style.top =top +'px';
  }
  else if(typeof(div.style.pixelLeft)!="undefined"){ 
    div.style.pixelLeft=left;
    div.style.pixelTop =top;
  }
}

function setDivVisibility(div,visible){
  (div.style||div).visibility=(visible)?
    ((window.opera && !document.documentElement)?('visible'):('inherit')):('hidden');
}

//////////////////////////////////////////////////////////////////////////////////

Menu.parts={ innerBorderWidth:0, innerBorderColor:"", cellSpaceWidth:0 }; 

divNum = 0;

function createDiv(){
  divName='dynDiv'+(divNum++);
  divCName="mymenu";

  if(document.body && document.body.insertAdjacentHTML){
    txt='<div id="'+divName+'" cont="'+divCName
       +'" style="position:absolute;visibility:hidden"><\/div>';   
    document.body.insertAdjacentHTML('BeforeEnd',txt);
    return (document.getElementById)?
      (document.getElementById(divName)):(document.all(divName));
  }
  else if(document.createElement){
    document.body.appendChild(div=document.createElement('DIV'));
    div.id=divName; 
    div.setAttribute('cont',divCName);
    with(div.style){
      position = 'absolute';     
      visibility='hidden';
    }
    return div; 
  }
  return null;    
}

Menu.eles=new Array();
Menu.menu_divs=new Array();
 
function onMouseOver(e){
  var ele = null;

  if(!e) e = window.event;

  if(e.target) ele = e.target;
  else if(e.srcElement) ele = e.srcElement;

  while(ele.getAttribute("cont")!="mymenu"){
    if(ele.getAttribute("cont")=="menu_td" && ele.getAttribute("name")){
      if(!this.parent_obj) break;
      var p_obj = this.parent_obj;
      var i = ele.getAttribute("name");

      if(this.preEle){
        var pre_ele=this.preEle;
        pre_ele.className=pre_ele.menu_out;
      }
      ele.className=ele.menu_over;

      if(this.subMenu){
        var sub_menu=this.subMenu;
        setDivVisibility(sub_menu,false);
        if(sub_menu.preEle) {
          sub_menu.preEle.className=sub_menu.preEle.menu_out;
        }      
        while(sub_menu.subMenu){
          sub_menu=sub_menu.subMenu;
          setDivVisibility(sub_menu,false);
          if(sub_menu.preEle) {
            sub_menu.preEle.className=sub_menu.preEle.menu_out;
          } 
        }       
      }         
      this.preEle = ele;
      Menu.eles[Menu.eles.length]=ele;
      if(!this.parent.items[i].link){
        this.style.cursor="default";
      }
      else{
        if(document.all) this.style.cursor="hand";
        else this.style.cursor="pointer";
      }
      if(this.parent.items[i].child){
        var child_div=this.parent.items[i].child.div;
        this.subMenu=child_div;
        setDivVisibility(child_div,true);
        Menu.menu_divs[Menu.menu_divs.length]=child_div;
      } 
      break;
    }
    ele = (window.external)?(ele.parentElement):(ele.parentNode);
  }
}

function onMouseOut(e){
  var ele = null;

  if(!e) e = window.event;

  if(e.relatedTarget) ele = e.relatedTarget;
  else if(e.toElement) ele = e.toElement;

  while(ele){
    if(ele.parent_obj) break;
    ele = (window.external)?(ele.parentElement):(ele.parentNode);
  }

  if(ele == null){
    for(i=0; i<Menu.menu_divs.length; i++)
      setDivVisibility(Menu.menu_divs[i],false);

    Menu.menu_divs=[];
    var on_nodes=Menu.eles;

    for(i=0; i<on_nodes.length; i++){
      var nd=on_nodes[i];
      nd.className = nd.menu_out;
      if(!nd.firstChild||!nd.firstChild.img_on) continue;
    }
    Menu.eles=[]; 
  }
}

function onMouseDown(e){
  var ele = null;

  if(!e) e = window.event;

  if(e.target) ele = e.target;
  else if(e.srcElement) ele = e.srcElement; 

  while(ele.getAttribute("cont")!="mymenu"){
    if(ele.getAttribute("cont")=="menu_td" && ele.getAttribute("name")){
      var i = ele.getAttribute("name");

      if(this.parent.items[i].target){
        if(this.parent.items[i].targetop){
          window.open(this.parent.items[i].link,this.parent.items[i].target,
                      this.parent.items[i].targetop);
        }else{
          window.open(this.parent.items[i].link,this.parent.items[i].target);
        }
      }else if(this.parent.items[i].link)
        location.href=this.parent.items[i].link;

      break;
    }
    ele = (window.external)?(ele.parentElement):(ele.parentNode);
  }
}


function getCbWidth(element,prop){
  var num=0;
  if(element.currentStyle){
    switch(prop){
    case "border-top-width":
     num=parseInt(element.currentStyle.borderTopWidth);    break;
    case "border-bottom-width":
     num=parseInt(element.currentStyle.borderBottomWidth); break;
    case "border-right-width":
     num=parseInt(element.currentStyle.borderRightWidth);  break;
    case "border-left-width":
     num=parseInt(element.currentStyle.borderLeftWidth);   break;
    }
  }
  else if(window.getComputedStyle){
     var css=window.getComputedStyle(element,'');
     num=parseInt(css.getPropertyValue(prop));
  }
  if(isNaN(num)) num=0;
  return num;
}

Menu.menuCount = 0;
                            
function Menu(){
  this.id='menu'+(Menu.menuCount++);
  this.menuCount=Menu.menuCount;
  this.marginY = 0; 
  this.marginX = 0;  
  this.div=createDiv();
  this.div.id='menuDiv'+this.menuCount;
  this.div.parent=this.div.parent_obj=this;
  this.w=arguments[0];
  this.total_width=0;
  this.itemH=arguments[1];
  this.dir=(arguments[4])?(arguments[4]):('vertical');
  this.textPos=(arguments[5])?(arguments[5]):('center');
  this.arrowPos=(arguments[6])?(arguments[6]):('right');
  this.text_margin = (typeof(arguments[7])!="number")?(0):(arguments[7]);
  this.anchor   = arguments[8];
  this.menu_out = (arguments[9])?(arguments[9]):('subMenu');
  this.menu_over= (arguments[10])?(arguments[10]):('subMenuOver');
  this.div_className = this.menu_out+'DIV';
  this.div.className = this.div_className;
  this.parts_style=arguments[11];

  if(this.parts_style){
    var par=this.parts_style; 
    this.innerBorderWidth=(typeof(par.innerBorderWidth)=="number")?
                         par.innerBorderWidth:1; 
    this.cellSpaceWidth=(typeof(par.cellSpaceWidth)=="number")?par.cellSpaceWidth:0;
    this.innerBorderColor=(par.innerBorderColor)?(par.innerBorderColor):('#c0c0c0');
  }

  this.borderTopWidth=getCbWidth(this.div,'border-top-width');
  this.borderBottomWidth=getCbWidth(this.div,'border-bottom-width');
  this.borderLeftWidth=getCbWidth(this.div,'border-left-width');
  this.borderRightWidth=getCbWidth(this.div,'border-right-width');
  this.cellBorderWidthTB = 0;
  this.cellBorderWidthLF = 0;

  if(this.dir=='horizon')this.total_width+=this.cellSpaceWidth;
  else this.total_width=this.w+this.cellSpaceWidth*2;

  if(this.menuCount==1) {
    if(typeof(arguments[2])!="number") {
      this.temp_left=arguments[2];
      this.left=0;
    }
    else this.left=arguments[2];
    this.top =arguments[3];
    moveDivTo(this.div,this.left,this.top);
  }
  else{
    this.left=0;
    this.top =0;
    this.marginX=arguments[2];
    this.marginY=arguments[3];
  }

  this.mtb=document.createElement('table');
  this.mtb.className=this.menu_out+'TABLE';
  this.mtb.style.borderWidth='0px';
  this.mtb.cellPadding='0px';
  this.mtb.cellSpacing=this.cellSpaceWidth+'px';
  this.mtbo=document.createElement('tbody');
  if(this.dir=="horizon"){
    this.mtr=document.createElement('tr');
    this.mtbo.appendChild(this.mtr);
  }  	
  this.mtb.appendChild(this.mtbo);
  this.div.appendChild(this.mtb);
  this.items=new Array();
  this.next_width=this.cellSpaceWidth;
  return this;
}


Menu.prototype.add = function(obj){ 
  obj.parent=this;

  if(this.dir=='vertical') obj.w=this.w;
  else if(this.dir=='horizon') {
    if(obj.w>0){
      this.total_width+=obj.w;
    }else{
      obj.w=this.w;
      this.total_width+=this.w;
    }
    if(this.cellSpaceWidth) this.total_width+=this.cellSpaceWidth;
  }
  obj.h=this.itemH;
  obj.dir=this.dir;
  obj.arrow_pos=this.arrowPos;
  this.items[obj.id]=this.items[this.items.length]=obj;
  this.items[obj.id].link=obj.link;
  this.items[obj.id].menu_out=(obj.menu_out)?(obj.menu_out):(this.menu_out);
  this.items[obj.id].menu_over=(obj.menu_over)?(obj.menu_over):(this.menu_over);

  var pre_obj=null;
  if(this.items.length>1){
    pre_obj=this.items[this.items.length-2];
    if(pre_obj.separate && this.innerBorderWidth>0){
      this.next_width=this.innerBorderWidth+this.cellSpaceWidth*2;
      if(this.dir=="horizon") this.total_width+=this.innerBorderWidth+this.cellSpaceWidth;
    }else
      this.next_width=this.cellSpaceWidth;
  }

  var mtr  =document.createElement('tr');
  var mtrl =mtr.cloneNode(false);
  var mtd  =document.createElement('td');
  var mtdl =mtd.cloneNode(false);
  mtd.setAttribute('cont','menu_td');

  var msp;
  if(obj.separate){
    msp = document.createElement('hr');
    msp.setAttribute('size','1');
    mtd.appendChild(msp);

//    mtr.setAttribute('height',5);
//    mtd.setAttribute('background','img/dot.gif');
  }else{
    msp = document.createElement('p');
    if(this.anchor && obj.link) msp.style.textDecoration='underline';

    var text=obj.text.replace(/\s/g,'&nbsp;');
    msp.innerHTML='<span style="white-space:nowrap">&nbsp;'+text+'<\/span>';
    mtd.appendChild(msp);
  }

  if(!obj.menu_out)
    mtd.menu_out = this.menu_out;
  else
    mtd.menu_out = obj.menu_out;
  mtd.className = mtd.menu_out;

  if(!obj.menu_over)
    mtd.menu_over = this.menu_over;
  else
    mtd.menu_over = obj.menu_over;

  if(this.dir=="horizon")
    this.mtr.appendChild(mtd);
  else{
    mtr.appendChild(mtd);
    this.mtbo.appendChild(mtr);
  }

  var btw=getCbWidth(mtd,'border-top-width');
  var bbw=getCbWidth(mtd,'border-bottom-width');
  var brw=getCbWidth(mtd,'border-right-width'); 
  var blw=getCbWidth(mtd,'border-left-width');
  this.cellBorderWidthTB =btw+bbw;
  this.cellBorderWidthLF =brw+blw;
  obj.w+=this.cellBorderWidthLF;
  obj.h+=this.cellBorderWidthTB;
  this.tw=obj.w
  this.itemTH=obj.h;

  if(this.dir=='vertical' && this.items.length<2) this.total_width+=this.cellBorderWidthLF;
  else if(this.dir=='horizon') this.total_width+=this.cellBorderWidthLF;

  var mtw,mth;
  if(navigator.userAgent.match(/Netscape/)&&
    parseFloat(navigator.vendorSub)<7.1) mtw=obj.w;
  else mtw=obj.w-this.cellBorderWidthLF;

  if(window.external && document.compatMode&&document.compatMode.match(/CSS/)) 
    mth=obj.h-this.cellBorderWidthTB;
  else mth=obj.h;    

  if(this.dir=='horizon'){
    obj.sub_defleft=(this.items.length>1)?(pre_obj.sub_defleft+pre_obj.w+this.next_width)
             :(this.left+this.borderLeftWidth+this.cellSpaceWidth);
    obj.sub_deftop=this.top+this.itemTH+2*this.cellSpaceWidth+this.borderTopWidth+this.borderBottomWidth; 
    if(this.items.length>1 && pre_obj.separate && this.innerBorderWidth>0){
      with(mtdl.style){
        backgroundColor=this.innerBorderColor;
        width=this.innerBorderWidth+'px';
        height=mth+'px';
      }
      this.mtr.insertBefore(mtdl,mtd);
    }
  }else if(this.dir=='vertical'){
    obj.sub_deftop=(this.items.length>1)?(pre_obj.sub_deftop+pre_obj.h
                  +this.next_width):(this.top+this.borderTopWidth+this.cellSpaceWidth);

    if(this.items.length>1 && pre_obj.separate && this.innerBorderWidth>0){
      with(mtdl.style){
        backgroundColor=this.innerBorderColor;
        width=mtw+'px';
        height=this.innerBorderWidth+'px';
      }
      mtrl.appendChild(mtdl);
      this.mtbo.insertBefore(mtrl,mtr);
    }
  }

  mtd.setAttribute('name',obj.id);
  with(mtd.style){
    width        = mtw+'px';
    height       = mth+'px';
    textAlign    = this.textPos;
    verticalAlign= 'middle'; 
    padding      = '0px';
  }
}

Menu.prototype.build = function(){

  if(window.controllers) this.div.style.width=this.total_width+'px';
  else this.mtb.style.width=this.total_width+'px';    

  var all_width=this.total_width+this.borderLeftWidth+this.borderRightWidth;
  if(this.temp_left=='center')
    this.left=Math.floor((getWindowWidth()-all_width)/2);

  var mx=this.marginX, my=this.marginY; 
  if(this.parent && this.parent.dir=='vertical' && this.parent.arrow_pos=='left'){
     this.left-=all_width;
  }

  for(i=0; i<this.items.length; i++){
    this.items[i].sub_defleft+=mx;
    this.items[i].sub_deftop+=my;
    if(this.temp_left) this.items[i].sub_defleft+=this.left;
  }
  moveDivTo(this.div,this.left+mx,this.top+my);

  this.div.onmouseover=onMouseOver;
  this.div.onmouseout =onMouseOut;
  this.div.onmousedown=onMouseDown;
  if(this.menuCount==1) setDivVisibility(this.div,true);
}

// menuItem initialize
function MenuItem(){ 
  this.id      = arguments[0];
  this.text    = arguments[0];
  this.link    = arguments[1];
  this.separate= arguments[2];
  this.target  = arguments[3];
  this.targetop= arguments[4];
  this.w = 0;
  this.h = 0;
  this.sub_deftop = 0;
  this.sub_defleft= 0;
  this.parent     = null;
  return this;
}

MenuItem.prototype.setMenu = function(obj){
  obj.parent=this;
  this.child=obj;
  obj.left=this.sub_defleft;
  obj.top =this.sub_deftop;
}

