#! /bin/sh
#
# test-sha2.sh
#
# Copyright (c) 2014 National Institute of Informatics in Japan,
# All rights reserved.
#
# This file or a portion of this file is licensed under the terms of
# the NAREGI Public License, found at http://www.naregi.org/download/index.html.
# If you redistribute this file, with or without modifications, you must
# include this notice in the file.
#

readonly MDGST="${top_builddir}/apps/mdgst"

test_digest()
{
    local hash="${1}"
    local message="${2}"
    local expect="${3}"

    local output="`printf '%s' \"${message}\" | ${MDGST} -hash \"${hash}\"`"

    if [ x"${expect}" != x"${output}" ]; then
        exit 1
    fi
}

##############################
# SHA-224

test_digest sha224 '' 'SHA224(stdin)= d14a028c2a3a2bc9476102bb288234c415a2b01f828ea62ac5b3e42f'

# RFC3874
# 3.2. Test Vector #2
test_digest sha224 'abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq' 'SHA224(stdin)= 75388b16512776cc5dba5da1fd890150b0c6455cb4f58b1952522525'


##############################
# SHA-256

test_digest sha256 '' 'SHA256(stdin)= e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855'

# FIPS PUB 180-2
# B.2 SHA-256 Example (Multi-Block Message) 
test_digest sha256 'abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq' 'SHA256(stdin)= 248d6a61d20638b8e5c026930c3e6039a33ce45964ff2167f6ecedd419db06c1'


##############################
# SHA-384

test_digest sha384 '' 'SHA384(stdin)= 38b060a751ac96384cd9327eb1b1e36a21fdb71114be07434c0cc7bf63f6e1da274edebfe76f65fbd51ad2f14898b95b'

# FIPS PUB 180-2
# D.2 SHA-384 Example (Multi-Block Message) 
test_digest sha384 'abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmnhijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu' 'SHA384(stdin)= 09330c33f71147e83d192fc782cd1b4753111b173b3b05d22fa08086e3b0f712fcc7c71a557e2db966c3e9fa91746039'


##############################
# SHA-512

test_digest sha512 '' 'SHA512(stdin)= cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'

# FIPS PUB 180-2
# C.2 SHA-512 Example (Multi-Block Message)
test_digest sha512 'abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmnhijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu' 'SHA512(stdin)= 8e959b75dae313da8cf4f72814fc143f8f7779c6eb9f7fa17299aeadb6889018501d289e4900f7e4331b99dec4b5433ac7d329eeb6dd26545e96e55b874be909'


##############################
# SHA-512/224

test_digest sha512-224 '' 'SHA512-224(stdin)= 6ed0dd02806fa89e25de060c19d3ac86cabb87d6a0ddd05c333b84f4'

# FIPS PUB 180-4
# A.2 Implementation Notes
# http://csrc.nist.gov/groups/ST/toolkit/examples.html
test_digest sha512-224 'abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmnhijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu' 'SHA512-224(stdin)= 23fec5bb94d60b23308192640b0c453335d664734fe40e7268674af9'


##############################
# SHA-512/256

test_digest sha512-256 '' 'SHA512-256(stdin)= c672b8d1ef56ed28ab87c3622c5114069bdd3ad7b8f9737498d0c01ecef0967a'

# FIPS PUB 180-4
# A.2 Implementation Notes
# http://csrc.nist.gov/groups/ST/toolkit/examples.html
test_digest sha512-256 'abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmnhijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu' 'SHA512-256(stdin)= 3928e184fb8690f840da3988121d31be65cb9d3ef83ee6146feac861e19b563a'
