#! /bin/sh
#
# test-sha1.sh
#
# Copyright (c) 2014 National Institute of Informatics in Japan,
# All rights reserved.
#
# This file or a portion of this file is licensed under the terms of
# the NAREGI Public License, found at http://www.naregi.org/download/index.html.
# If you redistribute this file, with or without modifications, you must
# include this notice in the file.
#

readonly MDGST="${top_builddir}/apps/mdgst"

test_digest()
{
    local hash="${1}"
    local message="${2}"
    local expect="${3}"

    local output="`printf '%s' \"${message}\" | ${MDGST} -hash \"${hash}\"`"

    if [ x"${expect}" != x"${output}" ]; then
        exit 1
    fi
}

test_digest sha1 '' 'SHA1(stdin)= da39a3ee5e6b4b0d3255bfef95601890afd80709'
test_digest sha1 'abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq' 'SHA1(stdin)= 84983e441c3bd26ebaae4aa1f95129e5e54670f1'
