#! /bin/sh
#
# test-opt-hash-multiple.sh
#
# Copyright (c) 2014-2017 National Institute of Informatics in Japan,
# All rights reserved.
#
# This file or a portion of this file is licensed under the terms of
# the NAREGI Public License, found at http://www.naregi.org/download/index.html.
# If you redistribute this file, with or without modifications, you must
# include this notice in the file.
#

PATH=/bin:/usr/bin
readonly MDGST="${top_builddir}/apps/mdgst"

trap 'rm -r -f test.$$' 0 1 2 3 11 15

mkdir -p test.$$

cat > test.$$/expect <<EOF
SHA1(stdin)= adc83b19e793491b1c6ea0fd8b46cd9f32e592fc
SHA256(stdin)= 01ba4719c80b6fe911b091a7c05124b64eeece964e09c058ef8f9805daca546b
SHA3-512(stdin)= 7186d65cda74aa1f4263638c0da5444614b8186935508a1d6d2b3afc53e9523ecb0f269590a7eb4d15dd60331359934f78c41a007807f6b394d3f7d059fb6638
EOF

echo '' | ${MDGST} -hash sha1,sha256,sha3-512 >test.$$/digest 2>&1 

if [ $? -ne 0 ]; then
    exit 1
fi

diff test.$$/expect test.$$/digest >/dev/null 2>&1
