#! /bin/sh
#
# test-opt-coreutils.sh
#
# Copyright (c) 2014 National Institute of Informatics in Japan,
# All rights reserved.
#
# This file or a portion of this file is licensed under the terms of
# the NAREGI Public License, found at http://www.naregi.org/download/index.html.
# If you redistribute this file, with or without modifications, you must
# include this notice in the file.
#

PATH=/bin:/usr/bin
readonly MDGST="${top_builddir}/apps/mdgst"

trap 'rm -r -f test.$$' 0 1 2 3 11 15

mkdir -p test.$$

cat > test.$$/expect <<EOF
01ba4719c80b6fe911b091a7c05124b64eeece964e09c058ef8f9805daca546b  stdin
EOF

echo '' | ${MDGST} -hash sha256 -coreutils >test.$$/digest 2>&1
if [ $? -ne 0 ]; then
    exit 1
fi

diff test.$$/expect test.$$/digest >/dev/null 2>&1
