#! /bin/sh
#
# test-md5.sh
#
# Copyright (c) 2014 National Institute of Informatics in Japan,
# All rights reserved.
#
# This file or a portion of this file is licensed under the terms of
# the NAREGI Public License, found at http://www.naregi.org/download/index.html.
# If you redistribute this file, with or without modifications, you must
# include this notice in the file.
#

readonly MDGST="${top_builddir}/apps/mdgst"

test_digest()
{
    local hash="${1}"
    local message="${2}"
    local expect="${3}"

    local output="`printf '%s' \"${message}\" | ${MDGST} -hash \"${hash}\"`"

    if [ x"${expect}" != x"${output}" ]; then
        exit 1
    fi
}

test_digest md5 '' 'MD5(stdin)= d41d8cd98f00b204e9800998ecf8427e'
test_digest md5 'a' 'MD5(stdin)= 0cc175b9c0f1b6a831c399e269772661'
test_digest md5 'abc' 'MD5(stdin)= 900150983cd24fb0d6963f7d28e17f72'
test_digest md5 'message digest' 'MD5(stdin)= f96b697d7cb7938d525a2f31aaf161d0'
test_digest md5 'abcdefghijklmnopqrstuvwxyz' 'MD5(stdin)= c3fcd3d76192e4007dfb496cca67e13b'
test_digest md5 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789' 'MD5(stdin)= d174ab98d277d9f5a5611c2c9f419d9f'
test_digest md5 '12345678901234567890123456789012345678901234567890123456789012345678901234567890' 'MD5(stdin)= 57edf4a22be3c955ac49da2e2107b67a'
