#! /bin/sh
#
# test-md4.sh
#
# Copyright (c) 2016 National Institute of Informatics in Japan,
# All rights reserved.
#
# This file or a portion of this file is licensed under the terms of
# the NAREGI Public License, found at http://www.naregi.org/download.
# If you redistribute this file, with or without modifications, you must
# include this notice in the file.
#

readonly MDGST="${top_builddir}/apps/mdgst"

# check whether the AiCrypto supports MD4...
chk_msg=`printf '' | ${MDGST} -hash md4 2>&1`
if [ x"$chk_msg" == x"UNKNOWN HASH ALGORITHM: md4" ]; then
    # skip current tests for MD4.
    # see GNU Automake (automake.info), Sec.15.1.
    echo "$chk_msg"
    exit 77
fi

test_digest()
{
    local hash="${1}"
    local message="${2}"
    local expect="${3}"

    local output="`printf '%s' \"${message}\" | ${MDGST} -hash \"${hash}\"`"

    if [ x"${expect}" != x"${output}" ]; then
        exit 1
    fi
}

test_digest md4 '' 'MD4(stdin)= 31d6cfe0d16ae931b73c59d7e0c089c0'
test_digest md4 'a' 'MD4(stdin)= bde52cb31de33e46245e05fbdbd6fb24'
test_digest md4 'abc' 'MD4(stdin)= a448017aaf21d8525fc10ae87aa6729d'
test_digest md4 'message digest' 'MD4(stdin)= d9130a8164549fe818874806e1c7014b'
test_digest md4 'abcdefghijklmnopqrstuvwxyz' 'MD4(stdin)= d79e1c308aa5bbcdeea8ed63df412da9'
test_digest md4 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789' 'MD4(stdin)= 043f8582f241db351ce627e153e7f0e4'
test_digest md4 '12345678901234567890123456789012345678901234567890123456789012345678901234567890' 'MD4(stdin)= e33b4ddc9c38f2199c3e7b164fcc0536'
