#! /bin/sh
#
# test-md2.sh
#
# Copyright (c) 2014 National Institute of Informatics in Japan,
# All rights reserved.
#
# This file or a portion of this file is licensed under the terms of
# the NAREGI Public License, found at http://www.naregi.org/download/index.html.
# If you redistribute this file, with or without modifications, you must
# include this notice in the file.
#

readonly MDGST="${top_builddir}/apps/mdgst"

# check whether the AiCrypto supports MD2...
chk_msg=`printf '' | ${MDGST} -hash md2 2>&1`
if [ x"$chk_msg" == x"UNKNOWN HASH ALGORITHM: md2" ]; then
    # skip current tests for MD2.
    # see GNU Automake (automake.info), Sec.15.1.
    echo "$chk_msg"
    exit 77
fi

test_digest()
{
    local hash="${1}"
    local message="${2}"
    local expect="${3}"

    local output="`printf '%s' \"${message}\" | ${MDGST} -hash \"${hash}\"`"

    if [ x"${expect}" != x"${output}" ]; then
        exit 1
    fi
}

test_digest md2 '' 'MD2(stdin)= 8350e5a3e24c153df2275c9f80692773'
test_digest md2 'a' 'MD2(stdin)= 32ec01ec4a6dac72c0ab96fb34c0b5d1'
test_digest md2 'abc' 'MD2(stdin)= da853b0d3f88d99b30283a69e6ded6bb'
test_digest md2 'message digest' 'MD2(stdin)= ab4f496bfb2a530b219ff33031fe06b0'
test_digest md2 'abcdefghijklmnopqrstuvwxyz' 'MD2(stdin)= 4e8ddff3650292ab5a4108c3aa47940b'
test_digest md2 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789' 'MD2(stdin)= da33def2a42df13975352846c30338cd'
test_digest md2 '12345678901234567890123456789012345678901234567890123456789012345678901234567890' 'MD2(stdin)= d5976f79d83d3a0dc9806c3c66f3efd8'
