/*
 * Copyright (c) 2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * the contents of this header were extracted from the "ok_aica.h?rev=907".
 *
 * This includes software developed by Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/).
 */

/**
 * @file ok_conf.h
 * This file defines functions and structures for configuring aica.cnf.
 */

/**
 * @defgroup ok_conf Configuration utilities
 * This module provides an API for configuring aica.cnf.
 */

#ifndef INCLUSION_GUARD_UUID_AE01C91E_0167_4AF8_BC58_96D660BD2574
#define INCLUSION_GUARD_UUID_AE01C91E_0167_4AF8_BC58_96D660BD2574

#ifdef	__cplusplus
extern "C" {
#endif

/**
 * Limits.
 * not final yet...
 */
#define CONF_PATH_MAX		256
#define CONF_SECT_NAME_MAX	64

/* aiconf.c */
#define CONF_PARSE_SVPATH_PARSE_SUCCESS  0
#define CONF_PARSE_SVPATH_PARSE_FAILURE -1
#define CONF_PARSE_SVPATH_ENOMEM        -2
#define CONF_PARSE_SVPATH_ERANGE_SVNAME -3
#define CONF_PARSE_SVPATH_ERANGE_CANAME -4
#define CONF_PARSE_SVPATH_ERANGE_RANAME CONF_PARSE_SVPATH_ERANGE_CANAME

/**
 * Get the contents of a section.
 */
char *conf_get_section(const char *fname, const char *begin, char *end);

/**
 * Clear comment lines in a buffer.
 */
int conf_clear_comment(char *buf);

/**
 * Locate the first occurrence of the newline from a buffer.
 */
char *conf_get_line(const char *bp, char **np, char *tmp);

/**
 * Locate the occurrence of the string "item" in a buffer.
 */
char *conf_comp_item(char *bp, const char *item);

/**
 * Get a character string that is the value of an item.
 */
int conf_getstr(char *buf, const char *name, char *ret, const int max);

/**
 * Get an integer that is the value of an item.
 */
int conf_getint(char *buf, const char *name, int *ret);

/**
 * Get true or false that is the value of an item.
 */
int conf_getbool(char *buf, const char *name, int *ret);    
int conf_parse_svpath(const char *svpath, char *svname, size_t svname_len,
		      char *caname, size_t caname_len);
char *aica_encry_passwd(char *passwd);
char *aica_decry_passwd(char *in);

#ifdef	__cplusplus
}
#endif

#endif	/* INCLUSION_GUARD_UUID_AE01C91E_0167_4AF8_BC58_96D660BD2574 */
