/* ok_caerr.h */
/*
 * Copyrightc 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#ifndef INCLUSION_GUARD_UUID_27925953_279E_48EB_8AF8_41B08C2BEF9F
#define INCLUSION_GUARD_UUID_27925953_279E_48EB_8AF8_41B08C2BEF9F

#ifdef  __cplusplus
extern "C" {
#endif

/*-----------------------------------------------
 * Define error location
 *---------------------------------------------*/
#define	ERR_LC_CA		0x80
#define	ERR_LC_REQ		0x81
#define	ERR_LC_CONF		0x82
#define	ERR_LC_PROF		0x83
#define	ERR_LC_LCMP		0x84
#define ERR_LC_CAD		0x85
#define ERR_LC_AUTH		0x86
#define ERR_LC_CRLP		0x87
#define ERR_LC_WEBE		0x88
#define ERR_LC_RAD		0x89
#define	ERR_LC_AICA		0x8a
#define	ERR_LC_ENR		0x8b

/*-----------------------------------------------
 * define error point
 *---------------------------------------------*/
/* ca */
#define ERR_PT_CA		0x10
#define ERR_PT_CACRL	0x20
#define ERR_PT_CAFILE	0x30
#define ERR_PT_CAASN1	0x40
#define ERR_PT_CALCERTS	0x50
#define ERR_PT_CANEW	0x60
#define ERR_PT_CAPRINT	0x70
#define ERR_PT_CASIGN	0x80
#define ERR_PT_CATOOL	0x90
#define ERR_PT_CACONF	0xa0
#define ERR_PT_CAPOL	0xb0
#define ERR_PT_CAOP 	0xc0
#define ERR_PT_CABIND 	0xd0
#define ERR_PT_CAPROF	0xe0

/* prof */
#define ERR_PT_PROF		0x10
#define ERR_PT_PFTMPL	0x20
#define ERR_PT_PFASN1	0x30
#define ERR_PT_PFFILE	0x40
#define ERR_PT_PFTOOL	0x50
#define ERR_PT_PFCONV	0x60

/* req */
#define ERR_PT_REQ		0x10

/* conf */
#define ERR_PT_CONF		0x10

/* lcmp */
#define ERR_PT_LCMP	0x10
#define ERR_PT_LCMPASE	0x20
#define ERR_PT_LCMPASD	0x30
#define ERR_PT_LCMPNET	0x40
#define ERR_PT_LCMPTOOL	0x50
#define ERR_PT_LCMPAPI	0x60

/* auth */
#define ERR_PT_AUTH	0x10

/* cad */
#define ERR_PT_CAD	0x10
#define ERR_PT_CADCA	0x20
#define ERR_PT_CADOP	0x30
#define ERR_PT_CADAUTH	0x40

/* crl publisher */
#define ERR_PT_CRLP	0x10
#define ERR_PT_CRLPCONF	0x20
#define ERR_PT_CRLPOP	0x30
#define ERR_PT_CRLLDAP	0x40

/* rad */
#define ERR_PT_RAD	0x10
#define ERR_PT_RADRA	0x20
#define ERR_PT_RADOP	0x30
#define ERR_PT_RADUSER	0x40
#define ERR_PT_RADMAIL	0x50
#define ERR_PT_RADLDAP	0x60

/* web enroll */
#define ERR_PT_WEBE 	0x10
#define ERR_PT_WEBMAIL  0x20
#define ERR_PT_WEBLDAP  0x30


/* aienroll */
#define ERR_PT_ENR 	0x10

/* aica */
#define ERR_PT_AICA	0x10
#define ERR_PT_AICABIND	0x20
#define ERR_PT_AICACONF	0x30
#define ERR_PT_AICALCRT	0x40
#define ERR_PT_AICANEW	0x50
#define ERR_PT_AICANEWSSL	0x60
#define ERR_PT_AICAOP	0x70
#define ERR_PT_AICAPOL	0x80
#define ERR_PT_AICAPROF	0x90
#define ERR_PT_AICASETEXT	0xa0
#define ERR_PT_AICASIGN	0xb0
#define ERR_PT_AICAUSER	0xc0

/*-----------------------------------------------
 * define error state
 *---------------------------------------------*/
/* ca */
#define ERR_ST_CA_			0x8000
#define ERR_ST_CA_NOCSTAT	0x8001
#define ERR_ST_CA_NORSTAT	0x8002
#define ERR_ST_CA_NOEXT		0x8003
#define ERR_ST_CA_BADCONF	0x8004
#define ERR_ST_CA_BADCSV	0x8005
#define ERR_ST_CA_BADSN		0x8006
#define ERR_ST_CA_BADSUBJECT	0x8007
#define ERR_ST_CA_NOPROF	0x8008
#define ERR_ST_CA_CTREVOKED	0x8010
#define ERR_ST_CA_CTEXPIRED	0x8011
#define ERR_ST_CA_NOTINUPD	0x8012
#define ERR_ST_CA_CANCELED	0x8020
#define ERR_ST_CA_POLMIS	0x8021

/* aica */
#define ERR_ST_INVALIDRSP	0x8030

/* aicrl ldap */
#define ERR_ST_LDAPINIT 	0x8040
#define ERR_ST_LDAPBIND 	0x8041
#define ERR_ST_LDAPMODIFY 	0x8042
#define ERR_ST_LDAPSEARCH 	0x8043
#define ERR_ST_LDAPNOENT 	0x8044
#define ERR_ST_LDAPNOVAL 	0x8045

/* enroll mail */
#define ERR_ST_SMTPSTART 	0x8050
#define ERR_ST_SMTPHELO 	0x8051
#define ERR_ST_SMTPFROM 	0x8052
#define ERR_ST_SMTPRCPT 	0x8053
#define ERR_ST_SMTPDATA 	0x8054
#define ERR_ST_SMTPMBODY 	0x8055

 
#ifdef  __cplusplus
}
#endif

#endif /* INCLUSION_GUARD_UUID_27925953_279E_48EB_8AF8_41B08C2BEF9F */
