/* ok_aimsg.h */
/*
 * Copyrightc 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#ifndef INCLUSION_GUARD_UUID_04347387_D460_4510_AB20_3B0FAAA38EEC
#define INCLUSION_GUARD_UUID_04347387_D460_4510_AB20_3B0FAAA38EEC

#ifdef  __cplusplus
extern "C" {
#endif

#define AIMSG_ERR_INTERNAL "CAd : server internal error"
#define AIMSG_ERR_NOREG    "CAd : required CA is not registered on this server"
#define AIMSG_ERR_CAINFO   "CAd : bad CA path : CA information not found"
#define AIMSG_ERR_CALIB    "CAd : bad CA environment : library not found"
#define AIMSG_ERR_USRAUTH  "CAd : user authentication failed"
#define AIMSG_ERR_CAPWDF   "CAd : bad CA path : CA passwd file not found"
#define AIMSG_ERR_NOUSER   "CAd : unknown user name"
#define AIMSG_ERR_NOUSERCERT "CAd : SSL client auth : user certificate not found."
#define AIMSG_ERR_USERNULL "CAd : broken user name or password"
#define AIMSG_ERR_BADPWD   "CAd : unmatched with hashed password"
#define AIMSG_ERR_NOGRANT  "CAd : user doesn't have enough grant"
#define AIMSG_ERR_CAPWD    "CAd : cannot get CA certificate and private key"
#define AIMSG_ERR_PFCTINFO "CAd : cannot get CA cert profile info"
#define AIMSG_ERR_PFCTFILE "CAd : cannot get CA cert profile file"
#define AIMSG_ERR_PFCLINFO "CAd : cannot get CA CRL profile info"
#define AIMSG_ERR_SSLHS    "CAd : error in the SSL handshake"
#define AIMSG_ERR_BINDGRT  "CAd : cannot perform bind operation"
#define AIMSG_ERR_SIGNGRT  "CAd : cannot perform sign operation"
#define AIMSG_ERR_LISTGRT  "CAd : cannot perform list operation"
#define AIMSG_ERR_PROFGRT  "CAd : cannot perform profile operation"
#define AIMSG_ERR_CERTGRT  "CAd : cannot perform Cert operation"
#define AIMSG_ERR_KEYGRT   "CAd : cannot perform Key operation"
#define AIMSG_ERR_CSRGRT   "CAd : cannot perform CSR operation"
#define AIMSG_ERR_CRLGRT   "CAd : cannot perform CRL operation"
#define AIMSG_ERR_SVOPGRT  "CAd : cannot perform server operation"
#define AIMSG_ERR_EXTGRT   "CAd : cannot perform extended operation"  
#define AIMSG_ERR_RENEWALGRT "CAd : cannot perform renewal operation"

#define AIMSG_RAERR_INTERNAL   "RAd : server internal error"
#define AIMSG_RAERR_NOREG      "RAd : required RA is not registered on this server"
#define AIMSG_RAERR_RAINFO     "RAd : bad RA path : RA session file not found"
#define AIMSG_RAERR_RALIB      "RAd : bad RA environment : library not found"
#define AIMSG_RAERR_SSLHS      "RAd : error in the SSL handshake"
#define AIMSG_RAERR_USRAUTH    "RAd : user authentication failed"
#define AIMSG_RAERR_PWDF       "RAd : bad RA path : RA passwd file not found"
#define AIMSG_RAERR_LICF       "RAd : bad RA path : RA license file not found"
#define AIMSG_RAERR_BADSBJ     "RAd : bad common name or email"
#define AIMSG_RAERR_LICDONE    "RAd : license ID is already used"
#define AIMSG_RAERR_NOUSER     "RAd : unknown user name"
#define AIMSG_RAERR_NOUSERCERT "RAd : SSL client auth : user certificate not found."
#define AIMSG_RAERR_USERNULL   "RAd : broken user name or password"
#define AIMSG_RAERR_BINDGRT    "RAd : cannot perform bind operation"
#define AIMSG_RAERR_SIGNGRT    "RAd : cannot perform sign operation"
#define AIMSG_RAERR_SIGNWAIT   "RAd : CSR already accepted. CA will return answer"
#define AIMSG_RAERR_SIGNDONE   "RAd : user certificate is already issued"
#define AIMSG_RAERR_LISTGRT    "RAd : cannot perform list operation"
#define AIMSG_RAERR_CERTGRT    "RAd : cannot perform Cert operation"
#define AIMSG_RAERR_CERTRVK    "RAd : user certificate is already revoked"
#define AIMSG_RAERR_RENEWALGRT    "RAd : cannot perform renewal operation"

#define AIMSG_ERR_BINDRSP "lcmp : cannot construct bind response"
#define AIMSG_ERR_SIGNRSP "lcmp : cannot construct sign response"
#define AIMSG_ERR_LISTRSP "lcmp : cannot construct list response"
#define AIMSG_ERR_PROFRSP "lcmp : cannot construct prof response"
#define AIMSG_ERR_CERTRSP "lcmp : cannot construct cert response"
#define AIMSG_ERR_CRLRSP  "lcmp : cannot construct crl response"
#define AIMSG_ERR_SVOPRSP "lcmp : cannot construct svop response"
#define AIMSG_ERR_EXTRSP  "lcmp : cannot construct ext response"
#define AIMSG_ERR_RENEWALRSP  "lcmp : cannot construct renewal response"
#define AIMSG_ERR_RDCLOSE "lcmp : connection closed by peer"
#define AIMSG_ERR_READ    "lcmp : cannot read message"
#define AIMSG_ERR_WRITE   "lcmp : cannot write message"
#define AIMSG_ERR_DECODE  "lcmp : cannot decode message"
#define AIMSG_ERR_ENCODE  "lcmp : cannot encode message"
  
#define AIMSG_CONSTART    "start remote CA operation"
#define AIMSG_RASTART     "start remote RA operation"
#define AIMSG_SUCBIND     "success bind operation"
#define AIMSG_SUCUNBIND   "success unbind operation"
#define AIMSG_SUCSIGN     "success sign operation"
#define AIMSG_SUCLIST     "success list operation"
#define AIMSG_SUCPROF     "success profile operation"
#define AIMSG_SUCCERT     "success cert operation"
#define AIMSG_SUCCSR      "success csr operation"
#define AIMSG_SUCCRL      "success crl operation"
#define AIMSG_SUCSVOP     "success server operation"
#define AIMSG_SUCEXT      "success extended operation"
#define AIMSG_SUCRENEWAL  "success renewal operation"
#define AIMSG_CONEND      "end remote CA operation"
#define AIMSG_RAEND       "end remote RA operation"

#ifdef  __cplusplus
}
#endif

#endif	/* INCLUSION_GUARD_UUID_04347387_D460_4510_AB20_3B0FAAA38EEC */
