/* ok_aica.h */
/*
 * Copyright (c) 2004-2015 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#ifndef INCLUSION_GUARD_UUID_BFFB8D7A_6B8F_4144_A18A_166400F57A0F
#define INCLUSION_GUARD_UUID_BFFB8D7A_6B8F_4144_A18A_166400F57A0F

#include <stdio.h>
#include <aicrypto/ok_tool.h>
#include <aicrypto/ok_store.h>
#include <aicrypto/ok_ssl.h>
#include "ok_ca.h"
#include "ok_lcmp.h"

#ifdef  __cplusplus
extern "C" {
#endif

#define MAXCA		64
#define MAXGROUP	128

/* aica daemon config info */
typedef struct aicad_conf {
	char store[256];	/* aica certificate store */

	char capath[MAXCA][128];	/* enable control CA by remote */
	char caname[MAXCA][64];	/* CA name as alias */
	char capwd[MAXCA][PWD_BUFLEN * 2];	/* CA master password */

	char sv_id[64];	/* ssl server certificate id */
	char sv_p12[128];	/* ssl server pkcs#12 file */
	char sv_p12_passwd[PWD_BUFLEN * 2];	/* password for server pkcs#12 */

	char errlog[128];	/* error log file name */
	char isslog[128];	/* issue log file name */
	char acclog[128];	/* access log file name */

	int errlog_rotate;
	int isslog_rotate;
	int acclog_rotate;

	int f_usessl;	/* don't set server certificate */
	int f_certreq;	/* set certificate request flag */
	int f_vfycert;	/* verify client certificate flag */

	int port;
	int listen;	/* port listen number */
	int ssl_recon;	/* SSL reconnection number */

	int revoke_at_rekey;
} CAdConf;

/* web enroll session structure */
typedef struct cw_accept_list AccList;
struct cw_accept_list {
	char name[64];
	char cn[64];
	char pwd[64];
	char email[64];
	char group[64];
	char sessionID[32];
	char caname[64];
	unsigned char keyID[32];

	int acceptID;	/* 4 byte */
	int serialNum;	/* 4 byte */
	int mode;	/* 4 byte */
	int isstype;	/* 4 byte */
	unsigned long containerTime;	/* 4 byte */
	unsigned long notAfter;	/* 4 byte */

	fpos_t pos;

	AccList *next;
};

typedef struct registered_ra_info {
	/* static values */
	char raname[64];	/* RA name (CA proxy server name) */
	char rapath[256];

	char svname[128];	/* CA server host name */
	char caname[64];	/* CA name */

	char userid[64];	/* user id for CA Server */
	char cl_id[64];	/* Client certificate id */
	char cl_pwd[PWD_BUFLEN * 2];	/* Client certificate or user id password */

	int authmode;
	int postmode;
	int offlineca;
	int usessl;
	int caport;
	int vfycert;
	int emsbjfilter;

	int cardchk;	/* ic card check flag for osaka univ. */
	int rawlid;	/* ldap search with raw license id */

	char sesspath[256];
	char pwdpath[256];
	char lidpath[256];

	char *grpname[MAXGROUP];	/* Group name as alias */
	char *grpprof[MAXGROUP];	/* Group profile name */
	char *grpemail[MAXGROUP];	/* Group email */
	char *grpbase[MAXGROUP];	/* Group base DN for LDAP */
	char *grphost[MAXGROUP];	/* Group host name for LDAP */
	char *grpbind[MAXGROUP];	/* Group bind name for LDAP */
	char *grpbindpwd[MAXGROUP];	/* Group bind password for LDAP */

	int smtpport;
	char smtphost[256];
	char smtpfrom[128];
	char admemail[128];
	char webhost[256];

	char gridcert[256];
	int ldaplogin;
	int ldapport;
	int ldapbind;
	char ldaphost[256];
	char ldapbase[256];
	char ldapadmin[256];
	char ldapadminpwd[PWD_BUFLEN * 2];
	char lidattr[64];
	char uidattr[64];
	char uquattr[64];
	char pinattr[64];
	char coopattr[64];
	char stuattr[64];

	/* non static values */
	int gid;
	AILock plock;

	AccList *list;

	char ldapmail[256];
	char ldapuser[256];
	char ldappwd[64];
	char ldaplang[8];

} RAdRegInfo;

typedef struct airad_conf {
	/* static values */
	char store[256];	/* aica certificate store */

	char sv_id[64];	/* ssl server certificate id */
	char sv_p12[128];	/* ssl server pkcs#12 file */
	char sv_p12_passwd[PWD_BUFLEN * 2];	/* password for server pkcs#12 */

	int port;
	int listen;	/* port listen number */
	int ssl_recon;	/* SSL reconnection number */

	int f_usessl;	/* don't set server certificate */
	int f_certreq;	/* set certificate request flag */
	int f_vfycert;	/* verify client certificate flag */

	char errlog[128];	/* error log file name */
	char isslog[128];	/* issue log file name */
	char acclog[128];	/* access log file name */

	int errlog_rotate;
	int isslog_rotate;
	int acclog_rotate;

	/* non static values */
	int ranum;

} RAdConf;

/* mail / cgi value list */
typedef struct ai_val_list {
	char *tag;
	char *val[MAXGROUP];
} AiVList;

/* Session record size */
#define WEB_SSBLOCK	400

/* Login mode (session information) */
#define AI_ENL_NEWISS	1
#define AI_ENL_WAITISS	2
#define AI_ENL_WAITGET	3
#define AI_ENL_ISSDONE	4
#define AI_ENL_REJECTED	5
#define AI_ENL_AUTHERR	6
#define AI_ENL_REVOKED	7
#define AI_ENL_NOPIN	8
#define AI_ENL_WAITUPD	9

/* password hash mode */
#define AI_ENPW_CRYPT	1
#define AI_ENPW_MD5 	2
#define AI_ENPW_SHA1	3

/* issue type */
#define AI_IS_COPYP10	0x00000001
#define AI_IS_DLP12	0x00000002
#define AI_IS_MOZILLA	0x00000100
#define AI_IS_SAFARI	0x00000200
#define AI_IS_IE7	0x00000400

/* user language */
#define AI_LNG_EN	0x00010000	/* default */
#define AI_LNG_JP	0x00020000

/* RA authentication mode (RAdRegInfo.authmode) */
#define AI_RA_AUTH_ANON	0
#define AI_RA_AUTH_IDPW 1
#define AI_RA_AUTH_LICE 2
#define AI_RA_AUTH_LCHA 4

#define NS_CRL		"http://sample.crl.co.jp/"
#define NS_COMMENT	"AiCA Comment."
#define NS_CERTTYPE	0xb0

#define	AICA_OP_ISSUE		100
#define	AICA_OP_SIGN		101
#define	AICA_OP_RESIGN		102
#define	AICA_OP_CRL		110
#define	AICA_OP_PRINT		120
#define	AICA_OP_LIST		121
#define	AICA_OP_REVOKE		130
#define	AICA_OP_UNREVOKE	131
#define	AICA_OP_EXPORT		132
#define	AICA_OP_IMPORT		133
#define	AICA_OP_DELETE		134
#define	AICA_OP_POSTCSR		135
#define	AICA_OP_CSV		140
#define	AICA_OP_NEWCA		150
#define	AICA_OP_ADDOP		151
#define AICA_OP_NEWSSL		152
#define AICA_OP_ADDSSLCT	153
#define	AICA_OP_RENEWCA		154
#define	AICA_OP_PFSET		160
#define	AICA_OP_PFEXT		170
#define	AICA_OP_PROF		180
#define	AICA_OP_BIND		190
#define	AICA_OP_USER		200
#define	AICA_OP_CSR 		210

/* aira operation */
#define	AIRA_OP_LIST	121
#define	AIRA_OP_CSR	210

/* log type */
#define AICA_LOG_ERR	0x01
#define AICA_LOG_ISS	0x02
#define AICA_LOG_ACC	0x04
#define AICA_LOG_STDOUT	0x08
#define AICA_LOG_STDERR	0x10
#define AICA_LOG_SYSLOG	0x20

/* SMTP messages */
#define MHELO   "ehlo "
#define MFROM   "mail from:"
#define MRCPT   "rcpt to:"
#define MDATA   "data\r\n"
#define MQUIT   "quit\r\n"

/**
 * Language used for e-mail bodies / LDAP in RA.
 */
enum ra_lang {		/* should conform to ISO 639 */
	RA_LANG_EN,	/* English */
	RA_LANG_JA,	/* Japanese */
};

/* aica_new.c */
int CA_init_Info(CA *ca);
int CA_init_pwd(CA *ca);
int CA_new_with_p12(CA *ca);
int CA_new_generate(CA *ca, int size, int type, int hash,
		    char *libname, char *label, int slot, int mofn);
int CA_update_P12andInfo(CA *ca, int flg);
int CA_set_defaulttags(CA *ca, CertDN *dir);
int CA_add_operator(CA *ca, int raadm);
int CA_mod_extension(CA *ca);

int CA_renew_selfcert(CA *ca);
int CA_renew_outpkcs10(CA *ca);

int CA_create_locks(CA *ca);
int CA_release_locks(CA *ca);

/* aica_newssl.c */
int CA_init_sslCA(char *path);
int CA_add_sslcert(CA *ca);

/* aica_pol.c */
int CA_set_policy(CA *ca, char *policy);
int CA_input_sbjtmpl(CertDN *dn);
int CA_input_profpolicy(unsigned char *flag);
int CA_input_profdnpolicy(unsigned char *flag);
void CA_print_profpolicy(unsigned char *flag);
void CA_print_profdnpolicy(unsigned char *flag);

/* aica_conf.c */
int CA_read_config(char *fname);
int ca_set_config(char *buf);

/* aica_print.c */
void CA_print(CA *ca, char *pfname, int pfall);
void CA_certstat_print(CA *ca, char *pfname, int sn, char *query);
void ca_stat_print(CertStat *stat, char *pfname, int sn);

/* aica_sign.c */
int CA_issue_cert(CA *ca, char *pfname, Cert **req, CertTemplate *tmpl,
		  int snum);
int Sign_do(CA *ca, Cert *req);
int Sign_certext(CA *ca, Cert *ct);
int Sign_before_after(CA *ca, Cert *ct);
int CA_do_revocation(CA *ca, int snum);
int ca_ask_yesno(char *txt, int yes);
int ca_ask_num(char *txt, int num);
int confirm_yes_no(char *prompt, int def);

/* aica_lcerts.c */
int CA_issue_alotof_certificates(CA *ca, char *fname, int hash);

/* aica_setext.c */
int CA_set_extensions(CA *ca, int extoid);
CertExt *CA_get_newext(CA *ca, int extoid);
int ca_ask_add_or_delete();
int ca_ask_onoff(char *txt, int on);
int ca_ask_yesno(char *txt, int yes);
int ca_ask_num(char *txt, int num);
int ca_ask_comment(char *txt, char *buf, int max);

/* aica_prof.c */
int CA_do_profile(CA *ca, int mode);
int get_tmpl_names(CA *ca, char tmpls[32][256]);
int CA_input_sbjtmpl(CertDN *dn);
int CA_input_profpolicy(unsigned char *flag);

/* aica_bind.c */
int CA_cl_bind(LCMP *lc);
int CA_cl_unbind(LCMP *lc);
int CA_cl_getsock(LCMP *lc, char *serv, int *auth);

/* aica_op.c */
int CA_cl_sign(LCMP *lc, Req **req, CertTemplate *tmpl);
int CA_cl_resign(LCMP *lc, Cert **ct);
int CA_cl_list(LCMP *lc);
int CA_cl_print(LCMP *lc);
int CA_cl_revoke(LCMP *lc, int rvk, char *query);
int CA_cl_unrevoke(LCMP *lc, int rvk, char *query);
int CA_cl_export(LCMP *lc, int snum);
int CA_cl_import(LCMP *lc, int snum, char *fname);
int CA_cl_delete(LCMP *lc, int snum);
int CA_cl_crl(LCMP *lc);
int CA_cl_csr(LCMP *lc);
int CA_cl_pfext(LCMP *lc, int extoid);
int CA_cl_pfset(LCMP *lc);
int CA_cl_addprof(LCMP *lc);
int CA_cl_delprof(LCMP *lc);
int CA_cl_renameprof(LCMP *lc);
int CA_cl_usermod(LCMP *lc, int pfmode);
int CA_cl_csv(LCMP *lc, char *fname, int hash);

/* aica_user.c */
int CA_user_add(CA *ca);
int CA_user_del(CA *ca);
int CA_user_mod(CA *ca, int pwdmode);
int ca_ask_grant(char *txt, int def);
int CA_user_addop(CA *ca);
int CA_user_addraadm(CA *ca);

/* common/acclist.c */
AccList *AccList_new();
void AccList_free(AccList *acc);
void AccList_free_all(AccList *acc);

/* req.c */
void config_set_defdir(char *str);
int req_config(char *fname, int num);
int get_key_pairs(Key **pub, Key **prv, int size, int type);
char *input_subject(CertDN *dn, char *prompt);
ExtGenNames *input_ipaddress();
OtherName *input_othername();
ExtGenNames *input_gennames(char *prompt);
int ca_set_defdir(CertDN *dn);

/* aicad_conf.c */
int CAd_read_config(char *fname, CAdConf *cf);
int cad_set_config(char *buf, CAdConf *cf);
int CAd_master_boot(CAdConf *cf);

/* aicad_ca.c */
int CAd_main(CAdConf *cf, SSL *s);

int CAd_log_connection(SSL *s);
int cad_get_peername(int sock, char *ret, int max);

int CAd_get_regnum(CAdConf *cf, char *caname);
int CAd_create_locks(CA *ca);
int CAd_release_locks(CA *ca);
void CAd_sig();

/* aicad_auth.c */
int CAd_user_auth(CAdConf *cf, LCMP *lc, int act);
int CAd_grant_check(LCMP *lc, CertProf *cpf, CRLProf *lpf, int *sn);
AuthInfo *CA_cmp_sslclient(AuthInfo *top, Cert *ct);

/* aicad_op.c */
int CAd_op_bindreq(CAdConf *cf, LCMP *lc);
int CAd_op_signreq(CAdConf *cf, LCMP *lc);
int CAd_op_listreq(CAdConf *cf, LCMP *lc);
int CAd_op_profreq(CAdConf *cf, LCMP *lc);
int CAd_op_certreq(CAdConf *cf, LCMP *lc);
int CAd_op_csrreq(CAdConf *cf, LCMP *lc);
int CAd_op_crlreq(CAdConf *cf, LCMP *lc);
int CAd_op_svopreq(CAdConf *cf, LCMP *lc);
int CAd_op_extreq(CAdConf *cf, LCMP *lc);
int CAd_op_renewalreq(CAdConf *cf, LCMP *lc);

int sighash2keyobj(int sig);
int extid_cmp(CertExt *e1, CertExt *e2);
int cad_add_exts(CA *ca, CertProf *cpf, CRLProf *lpf, LO_ProfReq *lo);
int cad_del_exts(CA *ca, CertProf *cpf, CRLProf *lpf, LO_ProfReq *lo);
int cad_upd_exts(CA *ca, CertProf *cpf, CRLProf *lpf, LO_ProfReq *lo);

/* aicad_log.c */
int CAd_log_open(CAdConf *cf);
void CAd_log_close();
int CAd_log_out(int type, LCMP *lc, char *msg, int opt, char *opmsg);
int CAd_log_checksize(FILE *fp, int size_kb);
int CAd_log_rotate(char *fname, FILE **fp);

#define CADLOG(type,lc,msg,opt,opmsg)	CAd_log_out((type),(lc),(msg),(opt),(opmsg))
#define CADERRLOG(lc,msg,opt,opmsg)	CAd_log_out(AICA_LOG_ERR,(lc),(msg),(opt),(opmsg))
#define CADISSLOG(lc,msg,opt,opmsg)	CAd_log_out(AICA_LOG_ISS,(lc),(msg),(opt),(opmsg))
#define CADACCLOG(lc,msg,opt,opmsg)	CAd_log_out(AICA_LOG_ACC,(lc),(msg),(opt),(opmsg))

/* aicrlpub.c */
int CApub_create_locks(CA *ca);
int CApub_release_locks(CA *ca);
void CApub_sig();

/* aicrl_conf.c */
int CApub_read_config(char *fname);
int capub_set_config(char *buf);

/* aicrl_op.c */
int CApub_cl_crl(LCMP *lc);

/* aicrl_log.c */
int CApub_log_open();
void CApub_log_close();
int CApub_log_out(int type, char *caname, char *msg);
int CApub_log_checksize(FILE *fp, int size_kb);
int CApub_log_rotate(char *fname, FILE **fp);

#define CRPLOG(type,name,msg)	CApub_log_out((type),(name),(msg))
#define CRPERRLOG(name,msg)	CApub_log_out(AICA_LOG_ERR,(name),(msg))
#define CRPISSLOG(name,msg)	CApub_log_out(AICA_LOG_ISS,(name),(msg))

/* aicrl_ldap */
#ifdef HAVE_LDAP_H
int CApub_ldap_bind();
int CApub_ldap_unbind();
int CApub_ldap_crlout(CRL *crl, char *attr);
#endif	/* HAVE_LDAP_H */

/* aicrl_http.c */
int CApub_web_crlout(CRL *crl);
char *CApub_url_get(char *url, int *ret_len);
char *CApub_url_post(char *url, char *post, int *ret_len);
SSL *CApub_connect_http(char *url, char *host, char *path);
int CApub_send(SSL *s, char *buf, int len);
int CApub_gets(SSL *s, char *buf, int max);
int CApub_recv_httpheader(SSL *s);
char *CApub_recv_body(SSL *s, int len);

/* airad.c */
int RAd_init_conf(RAdConf *cf);
int RAd_init_rainfo(RAdRegInfo *reg);
void RAd_clean_conf(RAdConf *cf);
void RAd_clean_rainfo(RAdRegInfo *reg);

/* airad_ra.c */
int RAd_main(RAdConf *cf, RAdRegInfo *reg, SSL *s);
int RAd_log_connection(SSL *s);
int rad_get_peername(int sock, char *ret, int max);

void RAd_sig();
int RAd_get_regnum(RAdRegInfo *reg, char *raname);

/* airad_conf.c */
int RAd_read_config(char *fname, RAdConf *cf, RAdRegInfo *reg);
int rad_set_config(char *buf, RAdConf *cf);
int rad_set_reginfo(char *buf, RAdRegInfo *cf);

/* airad_log.c */
int RAd_log_open(RAdConf *cf);
void RAd_log_close();
int RAd_log_out(int type, LCMP *lc, char *msg, int opt, char *opmsg);
int RAd_log_checksize(FILE *fp, int size_kb);
int RAd_log_rotate(char *fname, FILE ** fp);

#define RADLOG(type,lc,msg,opt,opmsg)	RAd_log_out((type),(lc),(msg),(opt),(opmsg))
#define RADERRLOG(lc,msg,opt,opmsg)	RAd_log_out(AICA_LOG_ERR,(lc),(msg),(opt),(opmsg))
#define RADISSLOG(lc,msg,opt,opmsg)	RAd_log_out(AICA_LOG_ISS,(lc),(msg),(opt),(opmsg))
#define RADACCLOG(lc,msg,opt,opmsg)	RAd_log_out(AICA_LOG_ACC,(lc),(msg),(opt),(opmsg))

/* airad_op.c */
int RAd_op_bindreq(RAdConf *cf, RAdRegInfo *reg, LCMP *cl, LCMP ** sv);
int RAd_op_signreq(RAdConf *cf, RAdRegInfo *reg, LCMP *cl, LCMP *sv);
int RAd_op_certreq(RAdConf *cf, RAdRegInfo *reg, LCMP *cl, LCMP *sv);
int RAd_op_listreq(RAdConf *cf, RAdRegInfo *reg, LCMP *cl, LCMP *sv);
int RAd_op_renewalreq(RAdConf *cf, RAdRegInfo *reg, LCMP *cl, LCMP *sv);
int RAd_op_proxy(RAdConf *cf, RAdRegInfo *reg, LCMP *cl, LCMP *sv);

/* airad_user.c */
int RAd_user_auth(RAdRegInfo *reg, LCMP *lc);
int RAd_auth_pwd(RAdRegInfo *reg, char *name, char *pwd);
int RAd_auth_license(RAdRegInfo *reg, char *license, char *pin);
int RAd_remove_licensefile(RAdRegInfo *info, char *license);

int RAd_get_passwd(RAdRegInfo *reg, char *pwd, char *salt, char *ret);
int RAd_check_passwd(RAdRegInfo *reg, char *encry, char *pwd);
int RAd_change_passwd(RAdRegInfo *reg, char *name, char *oldpwd, char *newpwd);

/* airad_util.c */
int RAd_set_session(RAdRegInfo *reg, char *name);
int RAd_load_session(RAdRegInfo *reg);
int RAd_reload_session(RAdRegInfo *reg, AccList *acc);
int RAd_update_session(RAdRegInfo *reg, AccList *acc);

char *RAd_get_name(RAdRegInfo *reg, Cert *ct);
int RAd_get_mode(RAdRegInfo *reg, char *name);
int RAd_get_grpnum(RAdRegInfo *info, char *group);
int RAd_gen_hash(char *license, char *hash);

AccList *RAd_findbyname(RAdRegInfo *reg, AccList *top, char *name);
AccList *RAd_findbyaccid(RAdRegInfo *reg, AccList *top, int id);
AccList *RAd_findbykeyid(RAdRegInfo *reg, AccList *top,
			 unsigned char *keyid);
AccList *RAd_findbycert(RAdRegInfo *reg, AccList *top, Cert *ct);

int RAd_parse_csv(char *in, char *out[], int out_max);

/* airad_ldap.c */
int RAd_ldap_addcert(RAdRegInfo *info, int op, Cert *ct, char *name,
		     char *gp, char *inpwd, char *license);

/* airad_mail.c */
int RAd_sendmail_sys2adm(RAdRegInfo *reg, AccList *acc, char *to,
			 char *cn, char *group, char *fname);
char *rad_get_mailbody(RAdRegInfo *reg, AccList *acc, char *from,
		       char *cn, char *group, char *fname);
int rad_send_mail(SSL *s, char *from, char *recipient, char *body);
SSL *rad_init_mail(char *smtphost, int smtpport);

/* aienr_conf.c */
int CAenr_read_config(char *fname);
int caenr_set_config(char *buf);
int caenr_set_reginfo(char *buf);
void caenr_init_conf();
void caenr_clean_conf();

/* aienr_log.c */
int CAenr_log_open();
void CAenr_log_close();
int CAenr_log_out(int type, char *caname, char *msg);
int CAenr_log_checksize(FILE *fp, int size_kb);
int CAenr_log_rotate(char *fname, FILE ** fp);

#define ENRLOG(type,name,msg)	CAenr_log_out((type),(name),(msg))
#define ENRACCLOG(name,msg)	CAenr_log_out(AICA_LOG_ACC,(name),(msg))
#define ENRISSLOG(name,msg)	CAenr_log_out(AICA_LOG_ISS,(name),(msg))
#define ENRERRLOG(name,msg)	CAenr_log_out(AICA_LOG_ERR,(name),(msg))

/* aiconfop.c -- configuration tool */
#define AICNF_OP_PRTITEM	0
#define AICNF_OP_ADDITEM	1
#define AICNF_OP_DELITEM	2
#define AICNF_OP_MODITEM	3
#define AICNF_OP_ADDCA		10
#define AICNF_OP_DELCA		11
#define AICNF_OP_ADDCRL		20
#define AICNF_OP_DELCRL		21
#define AICNF_OP_ADDRA		30
#define AICNF_OP_DELRA		31
#define AICNF_OP_SETSALT	40

int aiconf_print_item(char *buf);
char *aiconf_write_item(char *buf, int mode);
#define aiconf_add_item(buf)	aiconf_write_item((buf), 0)
#define aiconf_mod_item(buf)	aiconf_write_item((buf), 1)
char *aiconf_del_item(char *buf);

char *aiconf_add_ca(char *buf);
char *aiconf_del_ca(char *buf);
char *aiconf_add_crl(char *buf);
char *aiconf_del_crl(char *buf);
char *aiconf_add_ra(char *buf);
char *aiconf_del_ra(char *buf);
char *aiconf_set_salt_val(char *buf);

#ifdef  __cplusplus
}
#endif

#endif /* INCLUSION_GUARD_UUID_BFFB8D7A_6B8F_4144_A18A_166400F57A0F */
