/* gridmapgen.h */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#ifndef INCLUSION_GUARD_UUID_3EB771F8_3BC0_46FF_B612_FD4FAF775FC0
#define INCLUSION_GUARD_UUID_3EB771F8_3BC0_46FF_B612_FD4FAF775FC0

#include <aicrypto/ok_ssl.h>

#ifdef  __cplusplus
extern "C" {
#endif

typedef struct grid_map_list GMapList;
struct grid_map_list{
  int refnum;
  char localuser[64];
  char globaluser[64];

  char subject[256];

  GMapList *next;
  GMapList *prev;
};


#define REFMAX 32

/* log type */
#define GMAP_LOG_ACC    0x01
#define GMAP_LOG_ERR    0x02


/* gridmapgen.c */
int GMap_get_mapfiles(GMapList **list);
int GMap_check_csvfile(GMapList **list);
int GMap_backup_mapfile();
int GMap_save_mapfile(GMapList *list);
GMapList *GMap_load_oldmapfile();
int GMap_modify_uudb(GMapList *list, GMapList *old);

/* gridmap_list.c */
GMapList *GMapList_new();
void GMapList_free(GMapList *gm);
void GMapList_free_all(GMapList *top);

GMapList *GMap_find_bylocal(GMapList *top,char *local);
GMapList *GMap_find_byglobal(GMapList *top,char *global);
GMapList *GMap_find_bysubject(GMapList *top,char *subject);

int GMap_mapfile2list(char *buf,GMapList **ret,int ref,int local);


/* gridmap_http.c */
char *GMap_get_urlfile(char *url);
int gmap_get_address(char *url, char *svname, int *port, char *fname, int *ssl);
SSL *gmap_get_sock(char *server, int port, int ssl);
char *gmap_get_webfile(SSL *sock, char *svname, int port, char *fname, int ssl);
int gmap_send_httpget(SSL *sock, char *svname, int port, char *fname, int ssl);
int gmap_recv_httpheader(SSL *s);
char *gmap_recv_body(SSL *s, int len);


/* gridmap_conf.c */
int GMap_read_config(char *fname);
int gmap_set_config(char *buf);


/* gridmap_log.c */
int GMap_log_open();
void GMap_log_close();
int GMap_log_out(int type, char *msg, char *opt);
int GMap_log_checksize(FILE *fp, int size_kb);
int GMap_log_rotate(char *fname,FILE **fp);

#define GMAPLOG(type,name,msg)   GMap_log_out((type),(name),(msg))
#define GMAPERRLOG(name,msg)     GMap_log_out(GMAP_LOG_ERR,(name),(msg))
#define GMAPACCLOG(name,msg)     GMap_log_out(GMAP_LOG_ACC,(name),(msg))

#ifdef  __cplusplus
}
#endif

#endif /* INCLUSION_GUARD_UUID_3EB771F8_3BC0_46FF_B612_FD4FAF775FC0 */
