/* gridmap_list.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gridmapgen.h"

/* allocate user map */
GMapList *GMapList_new(){
  GMapList *ret;

  if((ret=(GMapList*)malloc(sizeof(GMapList)))==NULL) return NULL;
  memset(ret,0,sizeof(GMapList));

  return ret;
}

/* free user map */
void GMapList_free(GMapList *gm){
  if(gm==NULL) return;
  free(gm);
}

void GMapList_free_all(GMapList *top){
  GMapList *next;
  while(top){
    next = top->next;
    GMapList_free(top);
    top = next;
  }
}

/* find user */
GMapList *GMap_find_bylocal(GMapList *top,char *local){
  while(top){
    if(!strcmp(top->localuser,local)) break;
    top = top->next;
  }
  return top;
}

GMapList *GMap_find_byglobal(GMapList *top,char *global){
  while(top){
    if(!strcmp(top->globaluser,global)) break;
    top = top->next;
  }
  return top;
}

GMapList *GMap_find_bysubject(GMapList *top,char *subject){
  while(top){
    if(!strcmp(top->subject,subject)) break;
    top = top->next;
  }
  return top;
}

/* create list from mapfile */
int GMap_mapfile2list(char *buf,GMapList **ret,int ref,int local){
  GMapList *gm,*hd;
  char *cp,*nx,*t;

  *ret = NULL;

  while(buf && *buf){
    if((nx=strchr(buf,'\n')) != NULL) {
      if(*(nx-1)=='\r') *(nx-1) = 0;
      *nx = 0; nx++;
    }

    cp = buf;
    while(*cp && ((*cp==' ')||(*cp=='\t'))) cp++;

    if(!strncmp(cp,"\"/",2)){
      cp++; t = cp;

      while(*t && ((*t!='"')||(*(t-1)=='\\'))) t++;

      if(*t==0){ buf=nx; continue; }
      *t = 0; t++;

      if((gm=GMapList_new())==NULL) goto error;
      strncpy(gm->subject,cp,254);

      cp = t;
      while(*cp && ((*cp==' ')||(*cp=='\t'))) cp++;
      t = cp;
      while(*t && (*t!=' ') && (*t!='\t')) t++;
      *t = 0;

      t = (local)?(gm->localuser):(gm->globaluser);
      strncpy(t,cp,62);
      gm->refnum = ref;

#ifdef _DEBUG
fprintf(stderr,"map %d: global=%s,subject=%s\n",local,gm->globaluser,gm->subject);
#endif
      if(*ret){
	hd->next=gm; gm->prev=hd; hd=gm;
      }else{
	*ret=hd=gm;
      }
    }

    buf=nx;
  }

  return 0;
error:
  if(*ret){ GMapList_free_all(*ret); *ret=NULL; }
  return -1;
}
