/* gridmap_conf.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gridmapgen.h"
#include "ok_conf.h"		/* configuration tools; conf_OPERATE(), etc. */
#include "afi_utils.h"

/* general info */
char workdir[CONF_PATH_MAX] = "";
char usermap[CONF_PATH_MAX] = "";
char gridmap[CONF_PATH_MAX] = "";
char uudb_bin[CONF_PATH_MAX] = "";

int interval = 60;

char proxy_host[256] = "";
int proxy_port = 0;

char refmap[REFMAX][128];
char refcerts[REFMAX][128];

char acclog[256] = "";
char errlog[256] = "";

int acclog_size = 256;
int errlog_size = 256;

/*-----------------------------------------
  set Grid mapfile configure
-----------------------------------------*/
int GMap_read_config(char *fname)
{
	char *buf = NULL;
	int err = -1;

	/* init */
	memset(refmap, 0, REFMAX * 128);
	memset(refcerts, 0, REFMAX * 128);

	/* get Grid Mapfile generator info */
	if ((buf = conf_get_section(fname, "Grid MapGen", NULL)) == NULL)
		goto done;

	err = gmap_set_config(buf);

done:
	if (buf)
		free(buf);
	return err;
}

/*-----------------------------------------
  set grid map information
-----------------------------------------*/
int gmap_set_config(char *buf)
{
	char tmp[64];
	int i;

	if (conf_getstr(buf, "work_dir", workdir, sizeof(workdir) - 2))
		goto error;
	if (conf_getint(buf, "interval", &interval))
		goto error;

	if (conf_getstr(buf, "usermap", usermap, sizeof(usermap) - 2))
		goto error;
	if (conf_getstr(buf, "gridmap", gridmap, sizeof(gridmap) - 2))
		goto error;
	if (conf_getstr(buf, "uudb_bin", uudb_bin, sizeof(uudb_bin) -2))
		goto error;

	if (conf_getstr(buf, "proxy_host", proxy_host, 254))
		goto error;
	if (conf_normalize_host(proxy_host) !=
	    CONF_NORMALIZE_HOST_PARSE_SUCCESS)
		goto error;
	if (conf_getint(buf, "proxy_port", &proxy_port))
		goto error;

	for (i = 0; i < REFMAX; i++) {
		sprintf(tmp, "refmap.%d", i);
		if (conf_getstr(buf, tmp, refmap[i], 126))
			goto error;
		if (refmap[i][0] == 0)
			break;

		sprintf(tmp, "refcerts.%d", i);
		if (conf_getstr(buf, tmp, refcerts[i], 126))
			goto error;
	}

	if (conf_getstr(buf, "acclog", acclog, 254))
		goto error;
	if (conf_getstr(buf, "errlog", errlog, 254))
		goto error;

	/* v1.0 has typo bug, so bug fixed (lotate -> rotate).
	 * but old aica.cnf may have lotate items. version compatibility
	 * should be considered.
	 */
	if (conf_getint(buf, "acclog_lotate", &acclog_size))
		goto error;
	if (conf_getint(buf, "errlog_lotate", &errlog_size))
		goto error;

	if (conf_getint(buf, "acclog_rotate", &acclog_size))
		goto error;
	if (conf_getint(buf, "errlog_rotate", &errlog_size))
		goto error;

	return 0;
error:
	return -1;
}
