/* cgi_common.h */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#ifndef INCLUSION_GUARD_UUID_3B895579_BA91_41EF_B87D_A882E2786D1B
#define INCLUSION_GUARD_UUID_3B895579_BA91_41EF_B87D_A882E2786D1B

#include <aicrypto/ok_tool.h>
#include <aicrypto/ok_spkac.h>
#include "ok_caerr.h"
#include "ok_aica.h"

#ifdef HAVE_LDAP_H
# include <ldap.h>
# if defined(HAVE_BER_MEMFREE)
#  define LDAP_BER_FREE(a,b) ber_memfree(a) /* OpenLDAP */
#  define BERELEMENT BerElement
# elif defined(HAVE_BER_FREE)
#  define LDAP_BER_FREE(a,b) ber_free((a),(b)) /* Oracle/Sun LDAP */
#  define BERELEMENT BerElement
# elif defined(HAVE_LDAP_BER_FREE)
#  define LDAP_BER_FREE(a,b) ldap_ber_free((a),(b)) /* Netscape LDAP */
#  define BERELEMENT void
# else
#  error need ber_memfree() or ber_free() or ldap_ber_free().
# endif
#else
# define LDAP void
# define ldap_unbind(a) (a)=NULL
#endif /* HAVE_LDAP_H */
/* FIXME?: Windows support like including <winldap.h> etc. */

#ifdef  __cplusplus
extern "C" {
#endif


/* query context */
#define QUERY_MAX 48
#define REF_MAX 4

typedef struct ai_query_context {
  struct url_query{
    char key[128];
    char value[256];
  } urlqs[QUERY_MAX];

  struct post_query{
    char key[128];
    unsigned char *value;
  } postqs[QUERY_MAX];
  
  struct http_cookie{
    char key[128];
    char value[256];
  } cooks[QUERY_MAX];
  
}AiQC;

/* CA server */
#define CA_NUM  2

typedef struct ai_ca_server{
  char svname[256];
  char caname[64];
  int caport;

  char certid[32];
  char clctpw[PWD_BUFLEN*2];
  char userid[32];
  char pwd[PWD_BUFLEN*2];

  char store[256];

  int usessl;
  int vfycert;

}AiCASv;

/* log output */
typedef struct ai_log_info{
  char acclog[256];
  char isslog[256];
  char errlog[256];

  int acclog_size;
  int errlog_size;
  int isslog_size;
  
}AiLogInfo;

/* mail send information */
typedef struct ai_mail_info{
  int smtpport;
  char smtphost[256];

  char caname[64];
  char raname[64];
  char admemail[128];
  char sysemail[128];
  char opemail[128];
  char enrollurl[256];
  char lang[8];

}AiMailInfo;

/* ldap server information */
typedef struct ai_ldap_info{
  int  ldapport; /* ldap port number */
  int  ldapbind; /* kind of authentication */

  char ldaphost[256];
  char ldapbase[256];
  char ldapadmin[256];
  char ldapadminpwd[PWD_BUFLEN*2];
  char uidattr[64];
  char lidattr[64];
  char pinattr[64];
  char uquattr[64];
  char coopattr[64];
  char stuattr[64];

}AiLDAPInfo;

/* user ldap entry */
typedef struct ai_ldap_entry{
  char *dn;
  char *cn;
  char *firstName,*lastName;
  char *mail;
  char *pin;
  char *group;

  char *employeeNumber;
  char *unit,*title,*tel1,*tel2,*fax1,*fax2;
  char *plang;
  char *postalCode,*postalAddress;
  char /*seeAlso,*/ *description,*labeledUri;
  char *o,*ou,*st,*l,*street;
  char *queryattr; /* not inetOrgPerson */

  unsigned char *ucert;

  char *glist[MAXGROUP];

}AiEntryInfo;

/* user information */
typedef struct ai_user_info {
  char name[256];
  char passwd[PWD_BUFLEN*2];
  char mail[256];
  char prname[256];
  char cn[256];

  char svname[64];
  char caname[64];

  int mode;
}AiUserInfo;

typedef struct ai_ldap_attrs {
  char *tag;
  char **val[MAXGROUP];
}AiLAttr;


/* cgi_util.c */
int cgi_read_query(AiQC *info);
int cgi_read_post(AiQC *info);
int cgi_read_cookie(AiQC *info);
char *cgi_find_urlquery(AiQC *info,char *key,int *index);
char *cgi_find_postquery(AiQC *info,char *key,int *index);
char *cgi_find_query(AiQC *info,char *key);
char *cgi_find_cookie(AiQC *info,char *key);

Req *cgi_csr_decode(char *in);
SPKAC *cgi_spkac_decode(char *in);
int get_dn_kind(char *dn);
int cgi_get_fmt(char *in);

int ai_htoc(char *in);
int ai_ctoh(int in, char *ret);
int ai_unescape_url(char *buf);
char *ai_escape_url(char *in,int len);
void ai_symbol_esc_sp(char *cp);

int cgi_dec_snum(char *p);
Cert *cgi_get_clientcert();
char *cgi_get_clientcertid();

void cgi_print_content(char *buf, AiVList *v);

int cgi_load_session(char *fname,AccList **top);
int cgi_reload_session(char *fname,AccList *acc);
int cgi_update_session(char *fname,AccList *acc);

int cgi_set_session(char *fname, AccList **top, AiUserInfo *uinfo, unsigned char *sessionID);
int cgi_add_session(char *fname, AccList **top, AccList *acc);
int cgi_set_sessiongrp(char *fname, AccList **top, AiUserInfo *uinfo, unsigned char *sessionID, char *group);
int cgi_check_session(AccList *top, char *name, char *sessionID);
int cgi_check_sessiongrp(AccList *top, char *name, char *sessionID, char *group);
int cgi_get_mode(AccList *top,AiUserInfo *uinfo);
int cgi_get_modegrp(AccList *top,AiUserInfo *uinfo,char *group);

AccList *cgi_findbyname(AccList *top, char *name);
AccList *cgi_findbynamegrp(AccList *top, char *name, char *group);
AccList *cgi_findbyaccid(AccList *top, int id);
AccList *cgi_findbysnum(AccList *top, int snum);
AccList *cgi_findbykeyid(AccList *top, unsigned char *keyid);

int cgi_gen_hash(char *license, char *hash);
int cgi_parse_csv(char *in, char *out[], int out_max);

AiEntryInfo *cgi_entryinfo_new();
void cgi_entryinfo_free(AiEntryInfo *e);

#ifdef __WINDOWS__
void cgi_cert_print(Cert *ct);
#endif

#ifdef __WINDOWS__
#define CERT_PRINT(x) cgi_cert_print(x)
#else
#define CERT_PRINT(x) Cert_print(x)
#endif

/* cgi_log.c */
int cgi_log_open(AiLogInfo *info);
void cgi_log_close();
void cgi_set_peer();
int cgi_log_out(AiLogInfo *info, int type, char *caname, char *msg, int opt);
int cgi_log_checksize(FILE *fp, int size_kb);
int cgi_log_rotate(char *fname,FILE **fp);

#define ENCLOG(info,type,name,msg,opt)   cgi_log_out((info),(type),(name),(msg),(opt))
#define ENCACCLOG(name,msg)     cgi_log_out(&info->log,AICA_LOG_ACC,(name),(msg),0)
#define ENCISSLOG(name,msg)     cgi_log_out(&info->log,AICA_LOG_ISS,(name),(msg),0)
#define ENCERRLOG(name,msg)     cgi_log_out(&info->log,AICA_LOG_ERR,(name),(msg),1)


/* cgi_mail.c */
SSL *cgi_init_mail(char *smtphost, int smtpport);
int cgi_send_mail(SSL *s, char *from, char *recipient, char *body);


/* cgi_ldap.c */
#ifdef HAVE_LDAP_H
int cgi_ldap_bind(LDAP *ld, char *dn, char *passwd, int method);
int cgi_mod_attr(LDAP *ld, char *dn, int op, char *attr, char *val);
int cgi_mod_attr_bin(LDAP *ld, char *dn, int op, char *attr, unsigned char *bin, int blen);

LDAPMod *get_ldapmov(int op,char *attr,char *val);
LDAPMod *get_ldapmov_bin(int op,char *atname,unsigned char *bin,int blen);
void ldapmod_free(LDAPMod *mod);
void ldapmod_bin_free(LDAPMod *mod);

int cgi_ldap_addcert(AiLDAPInfo *info, int op, char *moddn, char *attr, Cert *ct);

int ldapdn2certdn(char *ldn, CertDN *cdn);
int certdn2ldapdn(CertDN *dn, char *ret, int ret_max);
int swap_dn(CertDN *dn);

int cgi_ldap_checkent(LDAP *ld, char *cn, char *base, char *license, char **dn, Cert **ret);
int cgi_ldap_addperson(LDAP * ld, char * name, char * base, char * email, char * o);
int cgi_ldap_addorg(LDAP * ld, char * org, char * base, char * flag);
int cgi_ldap_replace_attr(LDAP * ld, char * dn, char * attr, char **vals);
int cgi_ldap_getmail(LDAP * ld, char * dn, char * name, char * mail);
int cgi_ldap_entcount(LDAP * ld, char *  cn, char * base, int *ret);
void cgi_strfree(char * str);

int cgi_ldap_attrvals(LDAP *ld, LDAPMessage *ent, AiLAttr *v);

#endif


/* cgi_http.c */
char* cgi_url_get(AiLogInfo *log, char *url, int *ret_len);
char* cgi_url_post(AiLogInfo *log, char *url, char *post, int *ret_len);

SSL *cgi_connect_http(char *url, char *host, char *path);
int cgi_send(SSL *s, char *buf, int len);
int cgi_gets(SSL *s, char *buf,int max);
int cgi_recv_httpheader(SSL *s);
char *cgi_recv_body(SSL *s, int len);


#ifdef  __cplusplus
}
#endif

#endif /* INCLUSION_GUARD_UUID_3B895579_BA91_41EF_B87D_A882E2786D1B */
