/* airegist.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_rand.h>
#include <aicrypto/ok_uconv.h>

#include "aienr_cgi.h"

#ifndef AICONFIG
#define AICONFIG "aica.cnf"
#endif

char conf[256]=AICONFIG;

/*
 * CGI main
 */
int main(int argc,char **argv){
  AiEnrollInfo info;
  char *cp = NULL;
  int ret = -1;

#ifdef __WINDOWS__
  WSADATA wsaData;
  if(WSAStartup(MAKEWORD(1, 1), &wsaData) != 0) goto done;
#endif

  /* initialize */
  RAND_init();
  if(aienr_init_eninfo(&info)) goto done;

  /* read CGI configure */
  if(aienr_read_config(conf,&info)) goto done;

  /* read urlquery & post & cookie string */
  if(cgi_read_query(&info.qc)) goto done;
  if(cgi_read_post(&info.qc)) goto done;
  if(cgi_read_cookie(&info.qc)) goto done;

  /* output */
  cp = cgi_find_query(&info.qc,"Op");

  if(!strncmp(cp,"Confirm",16)){
    if(aiop_regiconfirm(&info)) goto done;

  }else if(!strncmp(cp,"Done",16)){
    if(aiop_regidone(&info)) goto done;

  }else if(!strncmp(cp,"Form",16)){
    if(aiop_regiform(&info)) goto done;

  }else if(!strncmp(cp,"AutoReg",16)){
    if(aiop_autoreg(&info)) goto done;

  }else if(!strncmp(cp,"AutoReg2",16)){
    if(aiop_autoreg2(&info)) goto done;

  }else if(!strncmp(cp,"AutoRegDone",16)){
    if(aiop_autoregdone(&info)) goto done;

  }else if(!strncmp(cp,"Login",16)){
    if(aiop_login(&info)) goto done;

  }else if(!strncmp(cp,"Login2",16)){
    if(aiop_login2(&info)) goto done;

  }else if(!strncmp(cp,"CtMg",16)){
    if(aiop_certmanage(&info)) goto done;

  }else if(!strncmp(cp,"RvkDone",16)){
    if(aiop_rvkdone(&info)) goto done;

  }else if(!strncmp(cp,"UpdPin",16)){
    if(aiop_updatepin(&info)) goto done;

  }else if(!strncmp(cp,"UpdPinDone",16)){
    if(aiop_updpindone(&info)) goto done;

  }else if(!strncmp(cp,"ViewCACt",16)){
    if(aiop_viewcacert(&info)) goto done;

  }else if(!strncmp(cp,"GetCACt",16)){
    if(aiop_getcacert(&info)) goto done;

  }else if(!strncmp(cp,"GetCRL",16)){
    if(aiop_getcrl(&info)) goto done;

  }else{
    /* default form */
    if(aiop_default(&info)) goto done;
  }

  ret = 0;
done:
  aienr_clean_eninfo(&info);
  RAND_cleanup();
  free_u2j_table();
#ifdef __WINDOWS__
  WSACleanup();
#endif
  return ret;
}
