/* airaadmin.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_rand.h>
#include <aicrypto/ok_uconv.h>

#include "aienr_cgi.h"

#ifndef AICONFIG
#define AICONFIG "aica.cnf"
#endif

char conf[256]=AICONFIG;

/*
 * CGI main
 */
int main(int argc,char **argv){
  AiEnrollInfo info;
  char *cp = NULL;
  int ret = -1;

  /* initialize */
  RAND_init();
  if(aienr_init_eninfo(&info)) goto done;

  /* read CGI configure */
  if(aienr_read_config(conf,&info)) goto done;
  strcat(info.sespath,"op");

  /* read urlquery & post & cookie string */
  if(cgi_read_query(&info.qc)) goto done;
  if(cgi_read_post(&info.qc)) goto done;
  if(cgi_read_cookie(&info.qc)) goto done;


  /* output */
  cp = cgi_find_query(&info.qc,"Op");

  if(!strncmp(cp,"UpdOP",16)){
    if(aira_updateop(&info)) goto done;

  }else if(!strncmp(cp,"UpdOPDone",16)){
    if(aira_updopdone(&info)) goto done;

  }else if(!strncmp(cp,"RvkOP",16)){
    if(aira_revokeop(&info)) goto done;

  }else if(!strncmp(cp,"RvkOPDone",16)){
    if(aira_rvkopdone(&info)) goto done;

  }else if(!strncmp(cp,"ViewAdmCt",16)){
    if(aira_viewraadm(&info)) goto done;

  }else if(!strncmp(cp,"ViewCGIConf",16)){
    if(aira_viewcgiconf(&info)) goto done;

  }else if(!strncmp(cp,"ListReq",16)){
    if(aira_listreq(&info)) goto done;

  }else if(!strncmp(cp,"SearchReq",16)){
    if(aira_searchreq(&info)) goto done;

  }else if(!strncmp(cp,"SearchReqDone",16)){
    if(aira_searchreqdone(&info)) goto done;

  }else if(!strncmp(cp,"ListUpdReq",16)){
    if(aira_listupdreq(&info)) goto done;

  }else if(!strncmp(cp,"ListRvkReq",16)){
    if(aira_listrvkreq(&info)) goto done;

  }else if(!strncmp(cp,"ConfirmReq",16)){
    if(aira_confirmreq(&info)) goto done;

  }else if(!strncmp(cp,"AcceptDone",16)){
    if(aira_acceptdone(&info)) goto done;

  }else if(!strncmp(cp,"RejectDone",16)){
    if(aira_rejectdone(&info)) goto done;

  }else if(!strncmp(cp,"ListOP",16)){
    if(aira_listop(&info)) goto done;

  }else if(!strncmp(cp,"ShowOP",16)){
    if(aira_showop(&info)) goto done;

  }else if(!strncmp(cp,"ModOP",16)){
    if(aira_modifyop(&info)) goto done;

  }else if(!strncmp(cp,"ViewOPCt",16)){
    if(aira_viewopcert(&info)) goto done;

  }else if(!strncmp(cp,"DelOP",16)){
    if(aira_delop(&info)) goto done;

  }else if(!strncmp(cp,"DelOPDone",16)){
    if(aira_delopdone(&info)) goto done;

  }else if(!strncmp(cp,"SearchOP",16)){
    if(aira_searchop(&info)) goto done;

  }else if(!strncmp(cp,"SearchOPDone",16)){
    if(aira_searchopdone(&info)) goto done;

  }else if(!strncmp(cp,"GetAdmCt",16)){
    if(aira_getadmcert(&info)) goto done;

  }else if(!strncmp(cp,"ViewCACt",16)){
    if(aira_viewcacert(&info)) goto done;

  }else if(!strncmp(cp,"GetCACt",16)){
    if(aira_getcacert(&info)) goto done;

  }else if(!strncmp(cp,"GetCRL",16)){
    if(aira_getcrl(&info)) goto done;

  }else if(!strncmp(cp,"Logout",16)){
    if(aira_logout(&info)) goto done;

  }else{
    /* login */
    if(aira_default(&info)) goto done;
  }

  ret = 0;
done:
  aienr_clean_eninfo(&info);
  RAND_cleanup();
  free_u2j_table();

  return ret;
}
