/* aira_mail.c */
/*
 * Copyright (c) 2004-2015 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_io.h>
#include <aicrypto/ok_uconv.h>

#include "aienr_cgi.h"

/* cgi_mail.c */
extern char hostname[];


/*------------------------------------------------------
  send email to admin
------------------------------------------------------*/
char *aira_get_mailbody(AiMailInfo *ml, AiEntryInfo *ei, char *id, char *fname){
  char path[256],tmp[512];
  char *cp,*t,*buf=NULL,*body=NULL;
  int i,j,k,len,cv;
  off_t sz;

#ifdef __WINDOWS__
  if(get_install_path(path,210)) goto done;
  strcat(path,"\\templates\\");
  strcat(path,ml->lang);
  strcat(path,"\\");
  strcat(path,fname);
#else
  if (strcmp("jp", ml->lang) == 0) {
	  /* XXX: Japanese locale is 'jp' for htdocs while 'ja' for mail. */
	  strcpy(ml->lang, "ja");
  }
  snprintf(path,254,"%s/templates/mail/%s/%s",DATADIR,ml->lang,fname);
#endif
  if((buf=(char*)get_file2buf(path,&sz))==NULL) goto done;

  i = strlen(buf) + 1024;
  if((body=(char*)malloc(i))==NULL) goto done;
  memset(body,0,i);

  cp = buf;
  do{
    AiVList v[] = {
      {"{ACCEPTID}",id},
      {"{LICENSEID}",id},
      {"{firstName}",ei->firstName},
      {"{lastName}",ei->lastName},
      {"{EMAIL}",ei->mail},
      {"{Gp}",ei->group},
      {"{Qu}",ei->queryattr},
      {"{ADMEMAIL}",ml->admemail},
      {"{OPEMAIL}",ml->opemail},
      {"{SYSEMAIL}",ml->sysemail},
      {"{CWENROLLSITE}",ml->enrollurl},
      {"{ENROLLURL}",ml->enrollurl},
      {"{HOSTNAME}",hostname},
      {"{RANAME}",ml->raname},
      {"{CANAME}",ml->caname},
      {NULL,NULL}
    };

    if((t=strstr(cp,"${"))==NULL){
      strcat(body,cp);
      break;
    }
    *t=0; t++; strcpy(tmp,"$");

    for(j=0; v[j].tag; j++){
      if(!memcmp(t,v[j].tag,strlen(v[j].tag)) && v[j].val[0]){
	/* check if ASCII or another */
	len = strlen(v[j].val[0]);
	for(k=cv=0; k<len; k++) cv |= 0x80 & (v[j].val[0])[k];

	if(cv){
	  /* maybe JP */
	  char jis_end[8] = { 0x1b, '(', 'B', 0 };
          UC_conv(UC_CODE_UTF8,UC_CODE_JIS,v[j].val[0],strlen(v[j].val[0]),tmp,512);
	  strcat(tmp,jis_end);
        }else{ /* ascii */
          strncpy(tmp,v[j].val[0],512);
        }
        t+=strlen(v[j].tag); break;
      }
    }
    strcat(body,cp);
    strcat(body,tmp);
    cp = t;
  }while(cp);

done:
  if(buf) free(buf);
  return body;
}

int aira_sendmail_sys2adm(AiMailInfo *ml, AiEntryInfo *ei, char *to, char *id, char *fname){
  char *body=NULL;
  SSL *ssl=NULL;
  int err=-1;

  /* initialize socket */
  if((ssl = cgi_init_mail(ml->smtphost,ml->smtpport)) == NULL) goto done;

  strcpy(ml->sysemail,"airad-system@");
  strncat(ml->sysemail,hostname,110);

  /* get mail body */
  if((body=aira_get_mailbody(ml,ei,id,fname))==NULL) goto done;

  /* send mail */
  if(cgi_send_mail(ssl,ml->sysemail,to,body)) goto done;

  err = 0;
done:
  SSL_free(ssl);
  if(body) free(body);
  return err;
}

int aira_sendmail_adm2usr(AiMailInfo *ml, AiEntryInfo *ei, char *from, char *id, char *fname){
  char *body=NULL;
  SSL *ssl=NULL;
  int err=-1;

  /* initialize socket */
  if((ssl = cgi_init_mail(ml->smtphost,ml->smtpport)) == NULL) goto done;

  /* get mail body */
  if((body=aira_get_mailbody(ml,ei,id,fname))==NULL) goto done;

  /* send mail */
  if(cgi_send_mail(ssl,from,ei->mail,body)) goto done;

  err = 0;
done:
  SSL_free(ssl);
  if(body) free(body);
  return err;
}
