/* airaoperator.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_rand.h>
#include <aicrypto/ok_uconv.h>

#include "aienr_cgi.h"

#ifndef AICONFIG
#define AICONFIG "aica.cnf"
#endif

char conf[256]=AICONFIG;

/*
 * CGI main
 */
int main(int argc,char **argv){
  AiEnrollInfo info;
  char *cp = NULL;
  int ret = -1;

  /* initialize */
  RAND_init();
  if(aienr_init_eninfo(&info)) goto done;

  /* read CGI configure */
  if(aienr_read_config(conf,&info)) goto done;
  strcat(info.sespath,"op");

  /* read urlquery & post & cookie string */
  if(cgi_read_query(&info.qc)) goto done;
  if(cgi_read_post(&info.qc)) goto done;
  if(cgi_read_cookie(&info.qc)) goto done;

  /* output */
  cp = cgi_find_query(&info.qc,"Op");

  if(!strncmp(cp,"ShowOP",16)){
    if(aiop_showop(&info)) goto done;

  }else if(!strncmp(cp,"ModOP",16)){
    if(aiop_modifyop(&info)) goto done;

  }else if(!strncmp(cp,"ViewOPCt",16)){
    if(aiop_viewopcert(&info)) goto done;

  }else if(!strncmp(cp,"ListReq",16)){
    if(aiop_listreq(&info)) goto done;

  }else if(!strncmp(cp,"SearchReq",16)){
    if(aiop_searchreq(&info)) goto done;

  }else if(!strncmp(cp,"SearchReqDone",16)){
    if(aiop_searchreqdone(&info)) goto done;

  }else if(!strncmp(cp,"ConfirmReq",16)){
    if(aiop_confirmreq(&info)) goto done;

  }else if(!strncmp(cp,"AcceptDone",16)){
    if(aiop_acceptdone(&info)) goto done;

  }else if(!strncmp(cp,"RejectDone",16)){
    if(aiop_rejectdone(&info)) goto done;

  }else if(!strncmp(cp,"ListUsr",16)){
    if(aiop_listuser(&info)) goto done;

  }else if(!strncmp(cp,"ShowUsr",16)){
    if(aiop_showuser(&info)) goto done;

  }else if(!strncmp(cp,"ModUsr",16)){
    if(aiop_modifyuser(&info)) goto done;

  }else if(!strncmp(cp,"ViewUsrCt",16)){
    if(aiop_viewusercert(&info)) goto done;

  }else if(!strncmp(cp,"DelUsr",16)){
    if(aiop_deluser(&info)) goto done;

  }else if(!strncmp(cp,"DelUsrDone",16)){
    if(aiop_deluserdone(&info)) goto done;

  }else if(!strncmp(cp,"UpdUsr",16)){
    if(aiop_updateuser(&info)) goto done;

  }else if(!strncmp(cp,"UpdUsrDone",16)){
    if(aiop_upduserdone(&info)) goto done;

  }else if(!strncmp(cp,"RvkUsr",16)){
    if(aiop_revokeuser(&info)) goto done;

  }else if(!strncmp(cp,"RvkUsrDone",16)){
    if(aiop_rvkuserdone(&info)) goto done;

  }else if(!strncmp(cp,"SearchUsr",16)){
    if(aiop_searchuser(&info)) goto done;

  }else if(!strncmp(cp,"SearchUsrDone",16)){
    if(aiop_searchuserdone(&info)) goto done;

  }else if(!strncmp(cp,"ListUpdReq",16)){
    if(aiop_listupdreq(&info)) goto done;

  }else if(!strncmp(cp,"ListRvkReq",16)){
    if(aiop_listrvkreq(&info)) goto done;

  }else if(!strncmp(cp,"UpdPin",16)){
    if(aiop_updatepin(&info)) goto done;

  }else if(!strncmp(cp,"UpdPinDone",16)){
    if(aiop_updpindone(&info)) goto done;

  }else if(!strncmp(cp,"GetOPCt",16)){
    if(aiop_getopcert(&info)) goto done;

  }else if(!strncmp(cp,"ViewCACt",16)){
    if(aiop_viewcacert(&info)) goto done;

  }else if(!strncmp(cp,"GetCACt",16)){
    if(aiop_getcacert(&info)) goto done;

  }else if(!strncmp(cp,"GetCRL",16)){
    if(aiop_getcrl(&info)) goto done;

  }else if(!strncmp(cp,"AutoReg",16)){
    if(aiop_autoreg(&info)) goto done;

  }else if(!strncmp(cp,"MultiAutoReg",16)){
    if(aiop_multiautoreg(&info)) goto done;

  }else if(!strncmp(cp,"Logout",16)){
    if(aiop_logout(&info)) goto done;

  }else{
    /* login */
    if(aiop_default(&info)) goto done;
  }

  ret = 0;
done:
  aienr_clean_eninfo(&info);
  RAND_cleanup();
  free_u2j_table();
  
  return ret;
}

