/* aiop_user.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_asn1.h>

#include "aienr_cgi.h"

/*-----------------------------------------------------
  check client certitifate
  return 1  .. ok,
         0  .. not ra admin,
         -1 .. system error
-------------------------------------------------------*/
int aiop_check_operator(AiEnrollInfo *info, Cert *ct, LCMP *lcmp, CertStat **st){
  CertExt *ext = NULL;
  unsigned char keyid[32];
  int i,mode=0,ret = -1;

  /* connect CA server */
  if(info->ca.usessl){
    if(LCMP_set_ssl(lcmp,info->ca.store,info->ca.certid,info->ca.clctpw,info->ca.vfycert))
      goto done;
    mode = LCMP_OPBRQ_ATSSLCL;
  }

  if(!info->offlineca){
    /* online ca mode */
    if(LCMP_bind_s(lcmp,info->ca.userid,info->ca.pwd,mode)) goto done;

    /* get RA Admin certificate status */
    if(LCMP_list_s(lcmp,"Operators",ct->serialNumber)){ ret=0; goto done; }

    /* check certificate serialnumber & subject & public key */
    if((*st=LCMP_get_statptr(lcmp))==NULL){ ret=0; goto done; }

    if(strstr((*st)->subject,", CN=RAOP")==NULL){ ret=0; goto done; }

	if(ct->pubkey){ /* full client certificate */
      if(cs_get_keyhash(ct->pubkey,keyid,&i)) goto done;
      if(memcmp(keyid,(*st)->keyID,20)){ ret=0; goto done; }
	}else{ /* parts of client certificate. probably, web server is IIS. */
      if(strncmp(ct->subject,(*st)->subject,strlen(ct->subject))){ ret=0; goto done; }
      if(strncmp(ct->issuer,lcmp->ca->cert->subject,strlen(ct->issuer))){ ret=0; goto done; }

      /* replace signature */
	  free(ct->signature);
	  if((ct->signature=malloc(32))==NULL){ ret=0; goto done; }
      memcpy(ct->signature,(*st)->keyID,20);
	}

    /* check status */
    if((*st)->state&(STAT_EXPIRED|STAT_REVOKED)){ ret=0; goto done; }
  }else{
    /* offline ca mode */
    if(strstr(ct->subject,", CN=RAOP")==NULL){ ret=0; goto done; }

    /* check extension */
    if((ext=CertExt_find(ct->ext,OBJ_NS_CERT_COMMENT))==NULL){ ret=0; goto done; }
    if(strcmp(((CE_Com*)ext)->comment,"Operators")){ ret=0; goto done; }
  }

  /* authentication success ! */
  ret = 1;

done:
  return ret;
}
