/* aimggen.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "ok_conf.h"
#include "cgi_common.h"

#ifdef HAVE_GD_H
#include <gd.h>
#include <gdfontg.h>
#include <aicrypto/ok_rand.h>

/*
 * CGI main
 */
int main(int argc,char **argv){
  gdImagePtr im = NULL;
  int shadow,black,line,bgcolor;
  int width  = 150;
  int height = 75;
  int brect[8];
  int i,rx,ry;
  time_t t;
  char *cry=NULL,*bs=NULL,str[32];
  unsigned char rnd[16];
  unsigned int num;

  if((im = gdImageCreate(width,height))==NULL) goto done;

  /* Allocate the color */
  shadow  = gdImageColorAllocate(im, 190, 190, 190);
  black   = gdImageColorAllocate(im, 0, 0, 0);
  line    = gdImageColorAllocate(im, 230, 110, 110);
  bgcolor = gdImageColorAllocate(im, 255, 255, 255);

  /* Draw a filled rectangle occupying the central area. */
  gdImageFilledRectangle(im, 0, 0, width-1, height-1, bgcolor);

  /* Draw a rectangle occupying the central area. */
  gdImageRectangle(im, 0, 0, width-1, height-1, black);

  time(&t);
  srand(t);

  /* Draw a dashed line from the upper left corner to the lower right corner. */
  rx = rand() % 50; /* get randam x */
  for(i=-80; i<150; i+=80){
    gdImageDashedLine(im, i+rx, 0, i+rx+99, 99, line);
  }
  ry = rand() % 75; /* get randam y */
  for(i=-75; i<75; i+=15){
    gdImageLine(im,0,i,150,i+ry,black);
  }
  rx = rand() % 100; /* get random x */
  for(i=0; i<250; i+=50){
    gdImageLine(im,i,0,i-rx,75,black);
  }

  /* generate random number text */
  RAND_init();
  RAND_bytes(rnd,16);
  num = ((rnd[0]<<16)|(rnd[1]<<8)|(rnd[2])) % 100000;

  sprintf(str,"%.5d%.2x%.2x%.2x%.2x%.2x",num,rnd[3],rnd[6],rnd[7],rnd[8],rnd[9]);
  if((cry = aica_encry_passwd(str))==NULL) goto done;
  if((bs = (char*)ai_escape_url(cry,strlen(cry)))==NULL) goto done;
  str[5] = 0;

  /* Draw random number text*/
  rx = 10 + (rnd[4] % 90);
  ry = 10 + (rnd[5] % 50);
  gdImageString(im, gdFontGiant,rx+1,ry+1,str,shadow);
  gdImageString(im, gdFontGiant,rx,ry,str,black);

  /* output stdout for CGI */
  printf("Set-Cookie: AIMGGENUM=%s\n", bs);
  printf("Content-type: image/png\n\n");

  /* Write img to stdout */
  gdImagePng(im, stdout);
  /*{FILE *fp; if(fp = fopen("e:\\tmp.png","w+")){gdImagePng(im, fp);fclose(fp);}}*/

done:
  /* Destroy it */
  if(im) gdImageDestroy(im);
  if(cry) free(cry);
  if(bs) free(bs);
  RAND_cleanup();

  return 0;	/* the return type of the main() is 'int'... */
}

#else /* HAVE_GD_H */

int main(int argc,char **argv){
  printf("Content-type: text/html\n\n");
  printf("libgd not found! can not generate random number image.\n");
  printf("Please contact web administrator.\n");
  printf("Maybe, NAREGI CA should be re-compiled.\n");

  return 0;	/* ditto */
}

#endif /* HAVE_GD_H */
