/* aienr_ldap.c */
/*
 * Copyright (c) 2004-2016 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_asn1.h>

#include "ok_conf.h"
#include "aienr_cgi.h"

#ifdef HAVE_LDAP_H /* FIXME: appropriate? */

int aienr_ldap_addcert( AiEnrollInfo * info, int op, Cert *ct, char *name, char *gp, char *inpwd, char *license){
  LDAP *ret=NULL;
  LDAPMessage *res=NULL, *res_tmp=NULL, *ent=NULL;
  char *cry=NULL, *pwd=NULL;
  char *base=NULL, *host=NULL, cs[256], *err;
  char hash[64], *search_attr=NULL, *search_val=NULL, binddn[512];
  char filter[256+17];
  int len, ok=-1;

  ASN1_skip_(ct->der,&len);

  if((info->postmode || info->offlineca) && inpwd && info->authmode!=AE_AUTH_LICE){ 
    /* postmode/offline-ca-mode and get_cert only use this pattern */
    pwd  = inpwd;

  }else{
    if((name=cgi_find_cookie(&info->qc,"ENLoginName"))==NULL||*name==0){
      err="cannot get login name from cookie"; goto done;
    }
    strncpy(binddn,name,512);
    if((gp=cgi_find_cookie(&info->qc,"ENGroupName"))==NULL||*gp==0){
      err="cannot get group name from cookie"; goto done;
    }
    if(info->authmode==AE_AUTH_IDPW){
      if((cry=cgi_find_cookie(&info->qc,"ENLoginPasswd"))==NULL||*cry==0){
	err="cannot get attribute from cookie"; goto done;
      }
      if((pwd=aica_decry_passwd(cry))==NULL){
	err="cannot convert attribute"; goto done;
      }
    }
  }

  if((info->gnum=aienr_get_grpnum(info,gp))<0){
    err="cannot get group number"; goto done;
  }
  if((host=info->grphost[info->gnum])==NULL){
    if((host=info->ld.ldaphost)==NULL){
      err="cannot get hostname"; goto done;
    }
  }
  if((base=info->grpbase[info->gnum])==NULL){
    if((base=info->ld.ldapbase)==NULL){
      err="cannot get LDAP base"; goto done;
    }
  }
  
  if((info->authmode==AE_AUTH_LICE)||(info->authmode==AE_AUTH_LCHA)){
    if(info->grpbind[info->gnum]!=NULL){
      strncpy(binddn,info->grpbind[info->gnum],512);
    }else{
      if(info->ld.ldapadmin[0] != '\0'){
	strncpy(binddn,info->ld.ldapadmin,512);
      }else{
	err="cannot get LDAP base"; goto done;
      }
    }
    if((pwd=info->grpbindpwd[info->gnum])==NULL){
      if((pwd=info->ld.ldapadminpwd )==NULL){
	err="cannot get LDAP base"; goto done;
      }
    }

    search_attr=info->ld.lidattr;
    cgi_gen_hash(license,hash);
    search_val=(info->rawlid)?(license):(hash);
  }else{
    search_attr="sAMAccountName";
    search_val=name;
  }
  sprintf( filter, "(%s=%s)", search_attr, search_val );


#ifdef WITHAD
  if((ret=ldap_open(host,info->ld.ldapport))==NULL){
    err="ldap_open error"; goto done;
  }
#else
  if((ret=ldap_init(host,info->ld.ldapport))==NULL){
    err="ldap_init error"; goto done;
  }
#endif

#ifdef WITHAD
  {
    SEC_WINNT_AUTH_IDENTITY wincred;
    char *attrs[] = {"distinguishedName",NULL};
    char **val=NULL;

    wincred.Flags = SEC_WINNT_AUTH_IDENTITY_ANSI;
    wincred.User = (unsigned char *)binddn;
    wincred.UserLength = strlen( binddn );
    wincred.Password = (unsigned char *)pwd;
    wincred.PasswordLength = strlen( pwd );
    wincred.Domain = (unsigned char *)( info->grpname[info->gnum] );
    wincred.DomainLength = strlen( wincred.Domain );

    if( ldap_bind_s( ret, NULL, (char*)&wincred, LDAP_AUTH_NEGOTIATE ) != LDAP_SUCCESS){
      err="ldap_bind error"; goto done;
    }

    if( ldap_search_s( ret, base, LDAP_SCOPE_BASE, NULL, NULL,0,&res_tmp) != LDAP_SUCCESS){
      err="ldap_search(BASE) error"; goto done;
    }

    if( ldap_search_s( ret, base, LDAP_SCOPE_SUBTREE, filter, attrs, 0, &res) != LDAP_SUCCESS){
      err="ldap_search(SUBTREE) error"; goto done;
    }

    if( ldap_count_entries( ret, res ) != 1 ){
      err="ldap_count_entries error"; goto done;
    }

    if( ( ent = ldap_first_entry( ret, res ) ) == NULL ) goto done;
    if( ( val = ldap_get_values( ret, ent, "distinguishedName" ))==NULL || *val==NULL ){
      err="cannot get distinguishiedname"; goto done;
    }

    if(cgi_mod_attr_bin( ret, *val, op, "userCertificate", ct->der, len)!= LDAP_SUCCESS){
      err="ldap_modify cert error"; goto done;
    }
    if((info->authmode==AE_AUTH_LICE)||(info->authmode==AE_AUTH_LCHA)){
      if(cgi_mod_attr_bin( ret, *val, LDAP_MOD_DELETE|LDAP_MOD_BVALUES, info->ld.lidattr, hash, strlen(hash) )!= LDAP_SUCCESS){
	err="ldap_modify license error"; goto done;
      }
    }
  }
#else
  {
    if(info->authmode==AE_AUTH_IDPW){
      if(!(strstr(name,"C=")||strstr(name,"c=")||strstr(name,"O=")||strstr(name,"o="))){
	memset (binddn,0,512);
	strncpy(binddn,info->ld.uidattr,64);
	strcat (binddn,"=");
	strncat(binddn,name,128);
	strcat (binddn,",");
	strncat(binddn,base,256);
      }else{
	strncpy(binddn,name,256);
      }
    }

    if(cgi_ldap_bind(ret,binddn,(char*)pwd,info->ld.ldapbind) != LDAP_SUCCESS){
      err="ldap_bind error"; goto done;
    }
    if((info->authmode==AE_AUTH_LICE)||(info->authmode==AE_AUTH_LCHA)){
      char * targetdn=NULL;
      if(ldap_search_s(ret,base,LDAP_SCOPE_SUBTREE,filter,NULL,0,&res) != LDAP_SUCCESS){
	err="ldap_search(SUBTREE) error"; goto done;
      }
      if(ldap_count_entries(ret,res)!=1){
	err="ldap_count_entries error"; goto done;
      }
      if((ent=ldap_first_entry(ret,res))==NULL){
	err="ldap_first_entry error"; goto done;
      }
      targetdn=ldap_get_dn(ret,ent);
      strncpy(binddn,targetdn,512);
      if(targetdn) ldap_memfree(targetdn);
    }

    if(cgi_mod_attr_bin( ret, binddn, op, "userCertificate;binary", ct->der,len )!=LDAP_SUCCESS){
      if(op&LDAP_MOD_REPLACE){
	/* replace failed. try to modify_add a userCertificate attribute. */
	if(cgi_mod_attr_bin( ret, binddn, LDAP_MOD_ADD|LDAP_MOD_BVALUES, "userCertificate;binary", ct->der,len)!=LDAP_SUCCESS){
	  err="ldap_modify cert error"; goto done;
	}
      }
    }
    if((info->authmode==AE_AUTH_LICE)||(info->authmode==AE_AUTH_LCHA)){
      search_val=(info->rawlid)?(license):(hash);
      if(cgi_mod_attr_bin(ret,binddn,LDAP_MOD_DELETE|LDAP_MOD_BVALUES, info->ld.lidattr, search_val, strlen(search_val) )!=LDAP_SUCCESS){
	err="ldap_modify license error"; goto done;
      }
    }
    if(info->authmode==AE_AUTH_LCHA){
      if(cgi_mod_attr(ret,binddn,LDAP_MOD_REPLACE,"st","ACTIVE")!= LDAP_SUCCESS){
	err="ldap_modify status error"; goto done;
      }
    }
  }
#endif

  ok = 0;
done:
  if(res) ldap_msgfree(res);
  if(res_tmp) ldap_msgfree(res_tmp);
  if(ret) ldap_unbind(ret);
  if(info->authmode==AE_AUTH_IDPW && pwd!=NULL) free(pwd);
  if(ok < 0){
    sprintf(cs,"%s : %s",name, err);
    ENCERRLOG(info->ca.caname,cs);
  }
  return ok;
}

#endif /* HAVE_LDAP_H */
