/* aienr_conf.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan, 
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must 
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef __WINDOWS__
#include <direct.h>
#define get
#else
#include <unistd.h>
#endif

#include "ok_conf.h"
#include "aienr_cgi.h"
#include "afi_utils.h"

char curpath[256] = "";

int aienr_set_config(char *buf, AiEnrollInfo *info);
int aienr_set_reginfo(char *buf, AiEnrollInfo *info);
int aienr_find_reginfo(char *conf);

/*-----------------------------------------------
  read configuration
-------------------------------------------------*/
int aienr_read_config(char *conf, AiEnrollInfo *info){
	char bg[64],end[64],*buf=NULL,*err="";
	int i,ok = -1;

#ifdef __WINDOWS__
	get_store_path(info->ca.store,254);
#else
	/* get store dir */
	if((buf=conf_get_section(conf,"[general info]","[general info end]"))==NULL){
		err="cannot get [general info] section"; goto done;
	}
	if(conf_getstr(buf,"store_dir",info->ca.store,254)){
		err="cannot get store_dir item"; goto done;
	}
	free(buf); buf=NULL;
#endif

	/* get RA server information */
	if((buf=conf_get_section(conf,"[RAd]","[RAd end]"))==NULL){
		err="cannot get [RAd] section"; goto done;
	}
	if(aienr_set_config(buf,info)){
		err="cannot get [RAd] items"; goto done;
	}
	free(buf); buf=NULL;

	/* find RA information number */
	if((i=aienr_find_reginfo(conf))<0){
		err="cannot find [RAd RegInfo X]"; goto done;
	}
	info->section = i;

	/* get RA RegInfo */
	snprintf(bg,64,"[RAd RegInfo %d]",i);
	snprintf(end,64,"[RAd RegInfo %d end]",i);
	if((buf=conf_get_section(conf,bg,end))==NULL){
		err="cannot get [RAd RegInfo X] section"; goto done;
	}
	if(aienr_set_reginfo(buf,info)){
		err="cannot get [RAd RegInfo X] items"; goto done;
	}
	free(buf); buf=NULL;

	ok = 0;
done:
	if(buf) free(buf);
	if(ok){
		printf("Content-type: text/plain\n\n");
		printf("WEB Enroll configuraion error<br>\n");
		printf("err: %s<br>\n",err);
		printf("curpath: %s<br>\n",curpath);
		printf("section: %i<br>\n",info->section);
	}
	return ok;
}


int aienr_set_config(char *buf, AiEnrollInfo *info){
	int ok = -1;

	/* output logs */
	if(conf_getstr(buf,"acclog",info->log.acclog,254)) goto done;
	if(conf_getstr(buf,"isslog",info->log.isslog,254)) goto done;
	if(conf_getstr(buf,"errlog",info->log.errlog,254)) goto done;

	/* v1.0 has typo bug, so bug fixed (lotate -> rotate).
	 * but old aica.cnf may have lotate items. version compatibility
	 * should be considered.
	 */
	if(conf_getint(buf,"acclog_lotate",&info->log.acclog_size)) goto done;
	if(conf_getint(buf,"isslog_lotate",&info->log.isslog_size)) goto done;
	if(conf_getint(buf,"errlog_lotate",&info->log.errlog_size)) goto done;

	if(conf_getint(buf,"acclog_rotate",&info->log.acclog_size)) goto done;
	if(conf_getint(buf,"isslog_rotate",&info->log.isslog_size)) goto done;
	if(conf_getint(buf,"errlog_rotate",&info->log.errlog_size)) goto done;

	ok = 0;
done:
	return ok;
}

int aienr_find_reginfo(char *conf){
	char *buf=NULL,begin[64],end[64];
	char path[264];
	int i,ret = -1;

	/* get current path */
	if(getcwd(curpath,254)==NULL) goto done;

	/* compare path */
	for(i=0; i<MAXCA; i++){
		snprintf(begin,64,"[RAd RegInfo %d]",i);
		snprintf(end,64,"[RAd RegInfo %d end]",i);

		if((buf=conf_get_section(conf,begin,end))==NULL) break;
		if(conf_getstr(buf,"rapath",path,254)) goto done;
		free(buf); buf=NULL;
		
		strcat(path,"/");
		strcat(path,"cgi");
#ifdef __WINDOWS__
		// windows path is case ignore 
		if(!stricmp(curpath,path)){ ret=i; break;}
#else
		if(!strcmp(curpath,path)){ ret=i; break;}
#endif
	}

done:
	return ret;
}

int aienr_set_reginfo(char *buf, AiEnrollInfo *info){
	char *tmp,*cp,grp[256],tag[32];
	int v1=0,v2=0,i,ok=-1;
	
	/* get web enroll info */
	if(conf_getstr(buf,"raname",info->ml.raname,62)) goto done;
	if(conf_getstr(buf,"rapath",info->rapath,254)) goto done;

	if(conf_getstr(buf,"ca_dir",info->ca.svname,254)) goto done;
	if(conf_parse_svpath(info->ca.svname,info->ca.svname,256,info->ca.caname,64)!=CONF_PARSE_SVPATH_PARSE_SUCCESS) goto done;
	strncpy(info->ml.caname,info->ca.caname,62);

	if(conf_getstr(buf,"ca_uid",info->ca.userid,30)) goto done;
	if(conf_getint(buf,"ca_port",&info->ca.caport)) goto done;
	if(conf_getstr(buf,"ca_pwd",info->ca.pwd,PWD_BUFLEN*2)) goto done;
#ifdef __WINDOWS__
	if(*info->ca.pwd && strstr(info->ca.pwd,"$cwcry${")){
#else
	if(*info->ca.pwd && strstr(info->ca.pwd,"$aicry${")){
#endif
		if((cp=strchr(info->ca.pwd,'}'))==NULL) goto done;
		*cp = 0;
		if((tmp=aica_decry_passwd(&info->ca.pwd[8]))==NULL) goto done;
		strcpy(info->ca.pwd,tmp);
		free(tmp);
	}

	if(conf_getbool(buf,"f_ssl_use",&info->ca.usessl)) goto done;
	if(conf_getbool(buf,"f_ssl_novfy",&v1)) goto done;
	if(conf_getbool(buf,"f_ssl_novfycrl",&v2)) goto done;

	if(v2) info->ca.vfycert = IF_NO_CRL_DONT_CHECK_REVOKED | DONT_VERIFY_CRL;
	if(v1) info->ca.vfycert = DONT_VERIFY;

	if(conf_getstr(buf,"cl_id",info->ca.certid,32)) goto done;
	if(conf_getstr(buf,"cl_id_pwd",info->ca.clctpw,PWD_BUFLEN*2)) goto done;

#ifdef __WINDOWS__
	if(*info->ca.clctpw && strstr(info->ca.clctpw,"$cwcry${")){
#else
	if(*info->ca.clctpw && strstr(info->ca.clctpw,"$aicry${")){
#endif
		if((cp=strchr(info->ca.clctpw,'}'))==NULL) goto done;
		*cp = 0;
		if((tmp=aica_decry_passwd(&info->ca.clctpw[8]))==NULL) goto done;
		strcpy(info->ca.clctpw,tmp);
		free(tmp); tmp = NULL;
	}

	if(conf_getint(buf,"interval",&info->interval)) goto done;
	if(conf_getbool(buf,"post_mode",&info->postmode)) goto done;
	if(conf_getbool(buf,"offline_ca_mode",&info->offlineca)) goto done;

	for(i=0; i<MAXGROUP; i++){
		memset(grp,0,256);

		sprintf(tag,"groupname.%d",i);
		if(conf_getstr(buf,tag,grp,30)) goto done;
		if(*grp == 0) break;
		if ((info->grpname[i] = strdup(grp)) == NULL) goto done;

		sprintf(tag,"groupprof.%d",i); *grp = 0;
		if(conf_getstr(buf,tag,grp,30)) goto done;
		if(*grp){
			if ((info->grpprof[i] = strdup(grp)) == NULL) goto done;
		}
		sprintf(tag,"groupemail.%d",i); *grp = 0;
		if(conf_getstr(buf,tag,grp,62)) goto done;
		if(*grp){
			if ((info->grpemail[i] = strdup(grp)) == NULL) goto done;
		}
		sprintf(tag,"groupbase.%d",i); *grp = 0;
		if(conf_getstr(buf,tag,grp,254)) goto done;
		if(*grp){
			if ((info->grpbase[i] = strdup(grp)) == NULL) goto done;
		}
		sprintf(tag,"grouphost.%d",i); *grp = 0;
		if(conf_getstr(buf,tag,grp,254)) goto done;
		if(*grp){
			if ((info->grphost[i] = strdup(grp)) == NULL) goto done;
		}
		sprintf(tag,"groupbind.%d",i); *grp = 0;
		if(conf_getstr(buf,tag,grp,254)) goto done;
		if(*grp){
			if ((info->grpbind[i] = strdup(grp)) == NULL) goto done;
		}
		sprintf(tag,"groupbindpwd.%d",i); *grp = 0;
		if(conf_getstr(buf,tag,grp,254)) goto done;
		if(*grp){
#ifdef __WINDOWS__
			if(strstr(grp,"$cwcry${")){
#else
			if(strstr(grp,"$aicry${")){
#endif
				if((cp=strchr(grp,'}'))==NULL) goto done;
				*cp = 0;
				if((tmp=aica_decry_passwd(&grp[8]))==NULL) goto done;
				strcpy(grp,tmp);
				free(tmp); tmp = NULL;
			}
			if ((info->grpbindpwd[i] = strdup(grp)) == NULL) goto done;
		}
	}

	/* user authntication */
	if(conf_getint(buf,"authmode",&info->authmode)) goto done;
	if(conf_getstr(buf,"wwwsessions",info->sespath,254)) goto done;
	if(conf_getstr(buf,"wwwpwd",info->pwdpath,254)) goto done;
	if(conf_getstr(buf,"wwwlicense",info->lidpath,254)) goto done;
	if(conf_getstr(buf,"ldap_host",info->ld.ldaphost,254)) goto done;
	info->ldaplogin = (*info->ld.ldaphost && info->authmode)?(1):(0);
	if(conf_getint(buf,"ldap_port",&info->ld.ldapport)) goto done;
	if(conf_getint(buf,"ldap_bind",&info->ld.ldapbind)) goto done;
	if(conf_getstr(buf,"ldap_base",info->ld.ldapbase,254)) goto done;
	if(conf_getstr(buf,"ldap_user_attr",info->ld.uidattr,64)) goto done;
	if(conf_getstr(buf,"ldap_license_attr",info->ld.lidattr,64)) goto done;
	if(conf_getstr(buf,"ldap_pin_attr",info->ld.pinattr,64)) goto done;
	if(conf_getstr(buf,"ldap_uquery_attr",info->ld.uquattr,64)) goto done;

	if(conf_getstr(buf,"ldap_student_attr",info->ld.stuattr,64)) goto done;
	if(conf_getstr(buf,"ldap_coop_attr",info->ld.coopattr,64)) goto done;
	if(conf_getbool(buf,"iccard_err_check",&info->cardchk)) goto done;
	if(conf_getbool(buf,"ldap_sch_rawlid",&info->rawlid)) goto done;

	if(conf_getstr(buf,"ldap_admin",info->ld.ldapadmin,254)) goto done;
	if(conf_getstr(buf,"ldap_admin_pwd",info->ld.ldapadminpwd,PWD_BUFLEN*2)) goto done;

#ifdef __WINDOWS__
	if(*info->ld.ldapadminpwd && strstr(info->ld.ldapadminpwd,"$cwcry${")){
#else
	if(*info->ld.ldapadminpwd && strstr(info->ld.ldapadminpwd,"$aicry${")){
#endif
		if((cp=strchr(info->ld.ldapadminpwd,'}'))==NULL) goto done;
		*cp = 0;
		if((tmp=aica_decry_passwd(&info->ld.ldapadminpwd[8]))==NULL) goto done;
		strcpy(info->ld.ldapadminpwd,tmp);
		free(tmp); tmp = NULL;
	}

	/* grid info */
	if(conf_getstr(buf,"gridcertpath",info->gridcert,254)) goto done;

	/* email */
	if(conf_getstr(buf,"smtp_host",info->ml.smtphost,254)) goto done;
	if(conf_normalize_host(info->ml.smtphost)!=CONF_NORMALIZE_HOST_PARSE_SUCCESS) goto done;
	if(conf_getstr(buf,"web_address",info->ml.enrollurl,254)) goto done;
	if(conf_getstr(buf,"admin_email",info->ml.admemail,126)) goto done;
	if(conf_getint(buf,"smtp_port",&info->ml.smtpport)) goto done;

	if(conf_getint(buf,"email_sbjfilter",&info->emsbjfilter)) goto done;
	
	/* other, referer */
	if(conf_getstr(buf,"ref_newcert",info->ref_newcert,254)) goto done;

	ok = 0;
done:
	return ok;
}

