/* aienr_cgi.h */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan, 
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must 
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#ifndef INCLUSION_GUARD_UUID_518D3DAF_52D8_4245_A254_7215DE056023
#define INCLUSION_GUARD_UUID_518D3DAF_52D8_4245_A254_7215DE056023

#include "cgi_common.h"

#ifdef  __cplusplus
extern "C" {
#endif

/* enroll cgi info */
typedef struct ai_enroll_info{
  /* configuration info */
  char rapath[256];
  char sespath[256];
  char pwdpath[256];
  char lidpath[256];

  AiCASv ca;

  int section;
  int interval;
  int authmode;
  int postmode;
  int offlineca;
  int ldaplogin; /* use ldap server (flag) */
  int emsbjfilter; /* emacs subject filter */

  int cardchk; /* ic card check flag for osaka univ. */
  int rawlid; /* ldap search with raw license id */

  AiLogInfo log; /* log output info */

  int gnum;
  char  *grpname[MAXGROUP];    /* Group name as alias */
  char  *grpprof[MAXGROUP];    /* Group profile name */
  char  *grpemail[MAXGROUP];   /* Group admin email */
  char  *grpbase[MAXGROUP];    /* Group base DN for LDAP */
  char  *grphost[MAXGROUP];    /* Group hostname for LDAP */
  char  *grpbind[MAXGROUP];    /* Group bind DN for LDAP */
  char  *grpbindpwd[MAXGROUP];    /* Group bind passwd for LDAP */

  char gridcert[256]; /* for UNICORE mapping */

  /* referer */
  char ref_newcert[256]; /* newcert page referer check */

  AiMailInfo ml;

  AiLDAPInfo ld;

  /* lock pointer */
  AILock plock;

  /* userinfo */
  AccList *list;

  /* post query & cookie context */
  AiQC qc;

}AiEnrollInfo;

/* authentication mode */
#define AE_AUTH_ANON 0
#define AE_AUTH_IDPW 1
#define AE_AUTH_LICE 2
#define AE_AUTH_WEB  3
#define AE_AUTH_LCHA 4

/* aienr_conf.c */
int aienr_read_config(char *conf, AiEnrollInfo *info);

/* aienr_op.c */
int aienr_default(AiEnrollInfo *info);
int aienr_login(AiEnrollInfo *info);
int aienr_user_newcert(AiEnrollInfo *info);
int aienr_send_csr(AiEnrollInfo *info);
int aienr_user_certop(AiEnrollInfo *info);
int aienr_revoke_cert(AiEnrollInfo *info);
int aienr_update_cert(AiEnrollInfo *info);
int aienr_get_cert(AiEnrollInfo *info);
int aienr_get_certdone(AiEnrollInfo *info);
int aienr_moz_certinst(AiEnrollInfo *info);
int aienr_change_pwd(AiEnrollInfo *info);
int aienr_update_pwd(AiEnrollInfo *info);
void aienr_print_err(AiEnrollInfo *info,char *err1,char *err2,LCMP *lc);
int aienr_send_csr_dl(AiEnrollInfo *info);
int aienr_get_certdone_dl(AiEnrollInfo *info);

/* aienr_user.c */
int aienr_check_login(AiEnrollInfo *info, AiUserInfo *uinfo);
int aienr_check_login_(AiEnrollInfo *info, char *name, char *pwd, AiUserInfo *uinfo);
int aienr_check_license(AiEnrollInfo *info, AiUserInfo *uinfo);
int aienr_check_license_(AiEnrollInfo *info, char *license, AiUserInfo *uinfo, char *pin);
int aienr_remove_licensefile(AiEnrollInfo *info, char *license, AccList *acc);
int aienr_gen_hash(char *license, char *hash);

int aienr_get_passwd(AiEnrollInfo *info,char *pwd,char *salt,char *ret);
int aienr_check_passwd(AiEnrollInfo *info,char *encry, char *pwd);
int aienr_change_passwd(AiEnrollInfo *info,char *group,char *name, char *oldpwd, char *newpwd);

int aienr_get_name(AiEnrollInfo *info,Cert *ct,AiUserInfo *uinfo, char **group);

/* aienr_util.c */
int aienr_init_eninfo(AiEnrollInfo *info);
void aienr_clean_eninfo(AiEnrollInfo *info);

int aienr_line2dn(char *in, CertDN *dn, char **err);

char *aienr_get_profname(AiEnrollInfo *info, char *group);
char *aienr_get_basedn(AiEnrollInfo *info, char *group);
char *aienr_get_host(AiEnrollInfo *info, char *group);
char *aienr_get_port(AiEnrollInfo *info, char *group);
char *aienr_get_userdn(AiEnrollInfo *info, char *group);
int aienr_get_grpnum(AiEnrollInfo *info, char *group);

int aienr_check_referer(AiEnrollInfo *info, char *page);
int aienr_get_count(AiEnrollInfo *info,char *name);

/* cgi_mail.c */
int aienr_sendmail2admin(AiMailInfo *ml, AccList *acc, char *cn, char *fname);
int aienr_sendmail_sys2adm(AiMailInfo *ml, AccList *acc, char *to, char *cn, char *fname);

/* aienr_ldap.c */
int aienr_ldap_addcert(AiEnrollInfo * info, int op, Cert *ct, char *name, char *gp, char *inpwd, char *license);

/* aira_op.c */
int aira_default(AiEnrollInfo *info);
void aira_print_err(AiEnrollInfo *info,char *err1,char *err2,LCMP *lc);
int aira_newreq(AiEnrollInfo *info);
int aira_updatereq(AiEnrollInfo *info);
int aira_revokereq(AiEnrollInfo *info);
int aira_viewraadm(AiEnrollInfo *info);
int aira_viewcgiconf(AiEnrollInfo *info);
int aira_listreq(AiEnrollInfo *info);
int aira_searchreq(AiEnrollInfo *info);
int aira_listop(AiEnrollInfo *info);
int aira_searchop(AiEnrollInfo *info);

/* aira_user.c */
int aira_check_admin(AiEnrollInfo *info,Cert *ct,LCMP *lc,CertStat **st);

/* aira_mail.c */
char *aira_get_mailbody(AiMailInfo *ml, AiEntryInfo *ei, char *id, char *fname);
int aira_sendmail_sys2adm(AiMailInfo *ml, AiEntryInfo *ei, char *to, char *id, char *fname);
int aira_sendmail_adm2usr(AiMailInfo *ml, AiEntryInfo *ei, char *from, char *id, char *fname);

/* aira_util.c */
int aira_add_regentry(AiEnrollInfo *info,LDAP *ld, char *rabase, AiEntryInfo *ei,
		      char *id, char *tmstr, char *ss);
int aira_get_count(AiEnrollInfo *info, char *name);
int aira_get_raentry(AiEnrollInfo *info,AiEntryInfo *e,char *cn,int raop,int gnum);
int aira_delete_raentry(AiEnrollInfo *info, char *cn, int raop, int gnum);
int aira_get_gridLid(AiEnrollInfo *info, char *attr, char *schID, char **lid, char **stuID);
int aira_get_ctentry(AiEnrollInfo *info,AiEntryInfo *e,Cert *ct,char *st);
Cert *aira_get_entrycert(AiEnrollInfo *info, char *cn, int raop, int gnum);
Cert *aira_get_entrycert_(AiEnrollInfo *info, char *cn, int raop, int gnum,char *retem,char *lang);

int gen_license_id2(char *email, char *ret);
int enr_gen_hash(char *license, char *hash);
int aira_lid2querykey(char *lid, char *que);

int aira_check_regcn(AiEnrollInfo *info, LDAP *ld, char *gbase, AiEntryInfo *e);
int aira_change_pin(AiEnrollInfo *info, char *cn, char *old, char *new, int raop, int gnum);

int aira_change_entryst(AiEnrollInfo *info,char *cn,char *status,char *license,int raop,int gnum);
int aira_change_entryst_(AiEnrollInfo *info,char *cn,char *status,char *license,
			 int raop,int gnum,int stop,char *que);

void cgi_get_lang(AiEnrollInfo *info,char *ret);
void cgi_get_deflang(char *ret);
void cgi_get_acclang(AccList *al,char *ret);
int cgi_get_langnum(AiEnrollInfo *info);
int aira_get_cadn(AiEnrollInfo *info, char *ret, int max);

char *cgi_html_path(AiEnrollInfo *info,char *base,char *file);
void cgi_check_lang(AiEnrollInfo *info);

int print_list_req(AiEnrollInfo *info,char *filter,char *from,int opf,int lmax,int start,int gnum,int sort);
void print_page_req(char *cgi,char *op,int lmax,int start,int sort,int count,char *query,int qtype,int gnum);

/* aireg_op.c */
void aiop_print_err(AiEnrollInfo *info,char *err1,char *err2,LCMP *lc);
int aiop_default(AiEnrollInfo *info);
int aiop_regiform(AiEnrollInfo *info);
int aiop_regiconfirm(AiEnrollInfo *info);
int aiop_regidone(AiEnrollInfo *info);
int aiop_login(AiEnrollInfo *info);
int aiop_login2(AiEnrollInfo *info);
int aiop_autoreg(AiEnrollInfo *info);
int aiop_autoreg2(AiEnrollInfo *info);
int aiop_autoregdone(AiEnrollInfo *info);
int aiop_certmanage(AiEnrollInfo *info);
int aiop_rvkconfirm(AiEnrollInfo *info);
int aiop_rvkdone(AiEnrollInfo *info);
int aiop_updatepin(AiEnrollInfo *info);
int aiop_updpindone(AiEnrollInfo *info);
int aiop_viewcacert(AiEnrollInfo *info);
int aiop_getcacert(AiEnrollInfo *info);
int aiop_getcrl(AiEnrollInfo *info);

/* aireg_util.c */
int aira_add_caaux(LDAP *ld, CertDN *dn, char *attrs[]);
int aira_add_entry(LDAP *ld, CertDN *dn, char *mch);
int aira_create_ca_entry(LDAP *ld, Cert *ca, char *cadn);

int aira_check_ldapenv(AiEnrollInfo *info,LDAP *ld, char *rabase, int max);
int aira_check_regsess(AiEnrollInfo *info,LDAP *ld, char *rabase, char *ssnum);
int aira_check_regsess2(AiEnrollInfo *info,LDAP *ld,char *gbase,char *base,int max, char *ssnum);

/* aira_op.c */
int aira_default(AiEnrollInfo *info);
int aira_logout(AiEnrollInfo *info);
int aira_updateop(AiEnrollInfo *info);
int aira_updopdone(AiEnrollInfo *info);
int aira_revokeop(AiEnrollInfo *info);
int aira_rvkopdone(AiEnrollInfo *info);
int aira_delop(AiEnrollInfo *info);
int aira_delopdone(AiEnrollInfo *info);
int aira_viewopcert(AiEnrollInfo *info);
int aira_viewraadm(AiEnrollInfo *info);
void print_cgi_conf(AiEnrollInfo *info);
int aira_viewcgiconf(AiEnrollInfo *info);
int aira_listreq(AiEnrollInfo *info);
int aira_searchreq(AiEnrollInfo *info);
int aira_searchreqdone(AiEnrollInfo *info);
int aira_listupdreq(AiEnrollInfo *info);
int aira_listrvkreq(AiEnrollInfo *info);
int aira_confirmreq(AiEnrollInfo *info);
int aira_rejectdone(AiEnrollInfo *info);
int aira_acceptdone(AiEnrollInfo *info);
int aira_listop(AiEnrollInfo *info);
int aira_showop(AiEnrollInfo *info);
int aira_modifyop(AiEnrollInfo *info);
int aira_searchop(AiEnrollInfo *info);
int aira_searchopdone(AiEnrollInfo *info);
int aira_viewcacert(AiEnrollInfo *info);
int aira_getadmcert(AiEnrollInfo *info);
int aira_getcacert(AiEnrollInfo *info);
int aira_getcrl(AiEnrollInfo *info);

/* airareg_op.c */
int aira_default(AiEnrollInfo *info);
int aira_regiform(AiEnrollInfo *info);
int aira_regiconfirm(AiEnrollInfo *info);
int aira_regidone(AiEnrollInfo *info);
int aira_login(AiEnrollInfo *info);
int aira_login2(AiEnrollInfo *info);
int aira_certmanage(AiEnrollInfo *info);
int aira_updconfirm(AiEnrollInfo *info);
int aira_rvkconfirm(AiEnrollInfo *info);
int aira_rvkdone(AiEnrollInfo *info);
int aira_updatepin(AiEnrollInfo *info);
int aira_updpindone(AiEnrollInfo *info);
int aira_viewcacert(AiEnrollInfo *info);
int aira_getcacert(AiEnrollInfo *info);
int aira_getcrl(AiEnrollInfo *info);

/* airae_op.c */
void airae_print_err(AiEnrollInfo *info,char *err1,char *err2,LCMP *lc);
int airae_login(AiEnrollInfo *info);
int airae_send_csr(AiEnrollInfo *info);
int airae_get_certdone(AiEnrollInfo *info);

/* aiop_op.c */
int aiop_default(AiEnrollInfo *info);
void aiop_print_err(AiEnrollInfo *info,char *err1,char *err2,LCMP *lc);
int aiop_check_session(AiEnrollInfo *info);
int aiop_logout(AiEnrollInfo *info);
int aiop_listreq(AiEnrollInfo *info);
int aiop_confirmreq(AiEnrollInfo *info);
int aiop_rejectdone(AiEnrollInfo *info);
int aiop_acceptdone(AiEnrollInfo *info);
int aiop_viewopcert(AiEnrollInfo *info);
int aiop_showop(AiEnrollInfo *info);
int aiop_modifyop(AiEnrollInfo *info);
int aiop_modifyuser(AiEnrollInfo *info);
int aiop_searchreq(AiEnrollInfo *info);
int aiop_searchreqdone(AiEnrollInfo *info);
int aiop_listuser(AiEnrollInfo *info);
int aiop_listupdreq(AiEnrollInfo *info);
int aiop_listrvkreq(AiEnrollInfo *info);
int aiop_showuser(AiEnrollInfo *info);
int aiop_viewusercert(AiEnrollInfo *info);
int aiop_revokeuser(AiEnrollInfo *info);
int aiop_rvkuserdone(AiEnrollInfo *info);
int aiop_updateuser(AiEnrollInfo *info);
int aiop_upduserdone(AiEnrollInfo *info);
int aiop_deluser(AiEnrollInfo *info);
int aiop_deluserdone(AiEnrollInfo *info);
int aiop_autoreg(AiEnrollInfo *info);
int aiop_multiautoreg(AiEnrollInfo *info);
int aiop_updatepin(AiEnrollInfo *info);
int aiop_updpindone(AiEnrollInfo *info);
int aiop_searchuser(AiEnrollInfo *info);
int aiop_searchuserdone(AiEnrollInfo *info);
int aiop_viewcacert(AiEnrollInfo *info);
int aiop_getopcert(AiEnrollInfo *info);
int aiop_getcacert(AiEnrollInfo *info);
int aiop_getcrl(AiEnrollInfo *info);

/* aiop_user.c */
int aiop_check_operator(AiEnrollInfo *info, Cert *ct, LCMP *lcmp, CertStat **st);




#ifdef  __cplusplus
}
#endif

#endif	/* INCLUSION_GUARD_UUID_518D3DAF_52D8_4245_A254_7215DE056023 */
