/* aienr_cgi.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ok_rand.h"
#include "ok_uconv.h"
#include "aienr_cgi.h"


#ifndef	AICONFIG
#define	AICONFIG "aica.cnf"
#endif

char conf[256]=AICONFIG;


/*
 * CGI main 
 */
int main(int argc,char **argv){
  AiEnrollInfo info;
  char *cp = NULL;
  int ret = -1;

  /* initialize */
  RAND_init();
  if(aienr_init_eninfo(&info)) goto done;

  /* read CGI configure */
  if(aienr_read_config(conf,&info)) goto done;

  /* read urlquery & post & cookie string */
  if(aienr_read_query(&info)) goto done;
  if(aienr_read_post(&info)) goto done;
  if(aienr_read_cookie(&info)) goto done;


  /* output */
  cp = aienr_find_query(&info,"Op");

  if(!strncmp(cp,"Login",16)){
    if(aienr_login(&info)) goto done;
  }else if(!strncmp(cp,"UserNewCert",16)){
    if(aienr_user_newcert(&info)) goto done;
  }else if(!strncmp(cp,"UserCertOp",16)){
    if(aienr_user_certop(&info)) goto done;
  }else if(!strncmp(cp,"RevokeCert",16)){
    if(aienr_revoke_cert(&info)) goto done;
  }else if(!strncmp(cp,"UpdateCert",16)){
    if(aienr_update_cert(&info)) goto done;
  }else if(!strncmp(cp,"SendCSR",16)){
    if(aienr_send_csr(&info)) goto done;
  }else if(!strncmp(cp,"SendCSRDl",16)){
    if(aienr_send_csr_dl(&info)) goto done;
  }else if(!strncmp(cp,"GetCert",16)){
    if(aienr_get_cert(&info)) goto done;
  }else if(!strncmp(cp,"GetCertDone",16)){
    if(aienr_get_certdone(&info)) goto done;
  }else if(!strncmp(cp,"GetCertDoneDl",16)){
    if(aienr_get_certdone_dl(&info)) goto done;
  }else if(!strncmp(cp,"MzrCertInst",16)){
    if(aienr_moz_certinst(&info)) goto done;
  }else if(!strncmp(cp,"ChangePWD",16)){
    if(aienr_change_pwd(&info)) goto done;
  }else if(!strncmp(cp,"UpdatePWD",16)){
    if(aienr_update_pwd(&info)) goto done;
  }else{
    if(aienr_default(&info)) goto done;
  }

  ret = 0;
done:
  aienr_clean_eninfo(&info);
  RAND_cleanup();
  free_u2j_table();

  return ret;
}

