/* aicrlupload.c */
/*
 * Copyrightc 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_rand.h>
#include <aicrypto/ok_uconv.h>

#include "aienr_cgi.h"
#include "ok_conf.h"

#ifndef AICONFIG
#define AICONFIG	"aica.cnf"
#endif
/*
 * if 'cacertdir' is NUL, it means that the CA certificate exists in the same
 * directory as aicrlupload.
 * Note that the following must be satisfied:
 *   strlen(cacertdir) + strlen("CA_name.cer") < CONF_PATH_MAX
 */
char cacertdir[CONF_PATH_MAX] = "";
char crldir[CONF_PATH_MAX] = "";	/* Likewise */

/* aicrl_util.c */
int aicrl_init_eninfo(AiEnrollInfo *info);
void aicrl_clean_eninfo(AiEnrollInfo *info);

/* aicrl_op.c */
int aicrl_default(AiEnrollInfo *info);
int aicrl_upload(AiEnrollInfo *info);

/*
 * CGI main
 */
int main(int argc, char **argv)
{
	AiEnrollInfo info;
	char *cp = NULL;
	char *buf = NULL;
	int ret = -1;

	/* initialize */
	RAND_init();
	if (aicrl_init_eninfo(&info))
		goto done;

	/* read a configuration file if it exists. */
	buf = conf_get_section(AICONFIG, "[aicrlupload]", NULL);
	if (buf != NULL) {
		conf_getstr(buf, "cacert_dir", cacertdir, sizeof(cacertdir) - 2);
		conf_getstr(buf, "crl_dir", crldir, sizeof(crldir) - 2);
		free(buf);
		buf = NULL;
	}

	/* read urlquery & post & cookie string */
	if (cgi_read_query(&info.qc))
		goto done;
	if (cgi_read_post(&info.qc))
		goto done;
	if (cgi_read_cookie(&info.qc))
		goto done;

	/* output */
	cp = cgi_find_query(&info.qc, "Op");

	if (!strncmp(cp, "Upload", 16)) {
		if (aicrl_upload(&info))
			goto done;
	} else {
		if (aicrl_default(&info))
			goto done;
	}

	ret = 0;
done:
	aicrl_clean_eninfo(&info);
	RAND_cleanup();
	free_u2j_table();

	return ret;
}
