/* aicrl_util.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_asn1.h>
#include <aicrypto/ok_base64.h>

#include "aienr_cgi.h"

/*-----------------------------------------------
  init & free
-------------------------------------------------*/
int aicrl_init_eninfo(AiEnrollInfo *info)
{
	char buf[128];

	memset(info, 0, sizeof(AiEnrollInfo));

	/* init lock */
	snprintf(buf, 126, "%s/RAdPwd%d", LOCKDIR, info->section);
	if ((info->plock = OK_init_lock(buf)) == NULL)
		goto error;

	return 0;
error:
	printf("Content-type: text/plain\n\n");
	printf("CRL uploader info init error (lock failed)<br>\n");
	return -1;
}

void aicrl_clean_eninfo(AiEnrollInfo *info)
{
	int i;

	if (info->plock)
		OK_release_lock(info->plock);

	for (i = 0; i < MAXGROUP; i++) {
		if (info->grpname[i]) {
			free(info->grpname[i]);
		}
		if (info->grpprof[i]) {
			free(info->grpprof[i]);
		}
		if (info->grpbase[i]) {
			free(info->grpbase[i]);
		}
		if (info->grphost[i]) {
			free(info->grphost[i]);
		}
	}

	for (i = 0; i < QUERY_MAX; i++)
		if (info->qc.postqs[i].value)
			free(info->qc.postqs[i].value);

	memset(info, 0, sizeof(AiEnrollInfo));
}

/*-----------------------------------------------
  CRL decoder
-------------------------------------------------*/
CRL *aicrl_decode(char *in)
{
	unsigned char *der = NULL;
	CRL *ret = NULL;
	int i;

	/* input has been unescaped */
	if ((der = Base64_decode(in, &i)) == NULL)
		goto done;
	ret = ASN1_read_crl(der);

done:
	if ((ret == NULL) && der)
		free(der);
	return ret;
}
