/* aicrl_op.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_err.h>
#include <aicrypto/ok_asn1.h>
#include <aicrypto/ok_pem.h>

#include "aienr_cgi.h"
#include "ok_conf.h"

/* aicrl_util.c */
CRL *aicrl_decode(char *in);

/* aicrlupload.c */
extern char cacertdir[];
extern char crldir[];

/*----------------------------------------------------------------------
	default : no operation
----------------------------------------------------------------------*/
int aicrl_default(AiEnrollInfo *info)
{

	printf("Content-type: text/html\n\n");

	printf("<html><head><title>CRL Uploader</title></head>\n");
	printf("<body><form method=post action=\"aicrlupload?Op=Upload\"><table>\n");
	printf("<tr><td>CA Name : </td><td><input type=text name=caname size=32></td></tr>\n");
	printf("<tr><td>CRL : </td><td><textarea cols=48 rows=15 name=CRL style=\"width:480px;\">copy and paste CRL text here.</textarea></td></tr></table><p>\n");
	printf("<input type=submit name=Upload value=Upload></form>\n");
	printf("</body></html>\n");

	return 0;
}

/*----------------------------------------------------------------------
	aicrl_upload : upload a CRL to the directorydcx
----------------------------------------------------------------------*/
int aicrl_upload(AiEnrollInfo *info)
{
	Cert *ca = NULL;
	CRL *crl = NULL;
	char *cp, *name;
	char path[CONF_PATH_MAX] = "";	/* also used as an error message. */
	int fmt, ret = -1;

	/* get SSL client cert if it exists */
	cp = cgi_find_query(&info->qc, "CRL");
	name = cgi_find_query(&info->qc, "caname");

	/*
	 * check pathname.
	 * strlen(".cer") == strlen(".crl") == strlen(".der") == 4
	 */
	if ((strlen(cacertdir) + strlen(name) + 4) >= sizeof(path)) {
		strcpy(path, "pathname of CA certificate too long");
		goto done;
	}
	if ((strlen(crldir) + strlen(name) + 4) >= sizeof(path)) {
		strcpy(path, "pathname of CRL too long");
		goto done;
	}

	printf("Content-type: text/plain\n\n");

	/* load CA certificate */
	snprintf(path, sizeof(path) - 1, "%s%s.cer", cacertdir, name);
	if ((ca = Cert_read_file(path)) == NULL)
		goto done;

	/* get CRL */
	fmt = cgi_get_fmt(cp);
	switch (fmt) {
	case 2:
		crl = PEM_read_crl_buf(cp);
		break;
	case 3:
		crl = aicrl_decode(cp);
		break;
	}
	if (crl == NULL) {
		//{FILE *fp;if(fp=fopen("#crlup_recv.txt","a+")){fprintf(fp,cp);fclose(fp);}}
		strcpy(path, "cannot decode form data to CRL");
		goto done;
	}

	/* verify CRL */
	if (CRL_signature_verify(ca, crl)) {
		strcpy(path, "CRL signature verify error");
		goto done;
	}
	switch (CRL_time_verify(crl)) {
	case 0:
		break;
	case X509_VFY_ERR_LASTUPDATE:
		strcpy(path, "CRL seems to have been sent from the future");
		goto done;
	case X509_VFY_ERR_NEXTUPDATE:
		strcpy(path, "CRL may be already expired");
		goto done;
	default:
		strcpy(path, "CRL_time_verify(): unspecified error");
		goto done;
	}
	/* write CRL */
	snprintf(path, sizeof(path) - 1, "%s%s.crl", crldir, name);
	if (PEM_write_crl(crl, path))
		goto done;
	snprintf(path, sizeof(path) - 1, "%s%s.der", crldir, name);
	if (ASN1_write_der(crl->der, path))
		goto done;

	printf("aicrl_upload : OK<br>\n");

	ret = 0;
done:
	if (ret) {
		printf("aicrl_upload : System error!!<br>\n");
		printf("%s", (OK_get_error())? (OK_get_errstr()) : (""));
		printf("<br>\n%s", path);
	}
	Cert_free(ca);
	CRL_free(crl);
	return ret;
}
