#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <aicrypto/version.h>	/* AiCrypto */

#ifndef CANONICAL_HOST_SYSTEM
#define CANONICAL_HOST_SYSTEM "system:unknown"
#endif

const char version_str[64] = PACKAGE_VERSION;
const char host_str[64] = CANONICAL_HOST_SYSTEM;
const char copyright_str[] = "\
Copyright (c) 2004-2014 National Institute of Informatics, Japan.\n\
Copyright (c) 1998-2004 Akira Iwata & Takuto Okuno. (AiCrypto)\n\
";

#ifndef HAVE_GETPROGNAME
const char *getprogname(void);
void setprogname(const char *progname);
#endif

/**
 * print version information
 */
void print_version (char *argv[]) {
	setprogname(argv[0]);

	printf("\
NAREGI-CA::%s %s (%s) %s\n\
with AiCrypto %s\n\
",
	       getprogname(), version_str, host_str, __DATE__,
	       aicrypto_version());
}
