/* readpw.c - test to read a password */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include "config.h"

#include <stdio.h>
#include <string.h>

#ifdef HAVE_SYS_IOCTL_H
#include <sys/ioctl.h>
#endif

#ifdef HAVE_TERMIOS_H
#include <termios.h>
#define TTY_STRUCT		struct termios
#define TTY_GET(tty, data)	tcgetattr(tty, data)
#define TTY_SET(tty, data)	tcsetattr(tty, TCSANOW, data)
#elif HAVE_TERMIO_H	/* for old system */
#include <termio.h>
#define TTY_STRUCT		struct termio
#define TTY_GET(tty, data)	ioctl(tty, TCGETA, data)
#define TTY_SET(tty, data)	ioctl(tty, TCSETA, data)
#endif
 
#include "ok_conf.h"

int main(int argc, char *argv[])
{
	TTY_STRUCT tio, save;
	FILE *tty;
	char buf[32], *cp, *cp2;
	int max;

	if ((tty = fopen("/dev/tty", "r")) == NULL) {
		printf("tty is stdin\n");
		tty = stdin;
	}

	TTY_GET(fileno(tty), &save);
	memcpy(&tio, &save, sizeof(TTY_STRUCT));
	tio.c_lflag &= ~ECHO;
	TTY_SET(fileno(tty), &tio);

	for (max = 3; max; --max) {
		fprintf(stderr, "input : ");
		fgets(buf, 32, tty);
		fprintf(stderr, "\nbuf is %s\n", buf);
	}

	TTY_SET(fileno(tty), &save);
	if (stdin != tty)
		fclose(tty);

	/* aiconf test */
	cp = aica_encry_passwd(buf);
	printf("encry: %s\n", (cp) ? (cp) : ("<NULL>"));

	if (cp) {
		cp2 = aica_decry_passwd(cp);
		printf("decry: %s\n", (cp2) ? (cp2) : ("<NULL>"));
	}
}
