/* randgen.c - generate a random buffer header */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_rand.h>

int main(int argc, char **argv){
  unsigned char buf[256];
  int i,j;

  /* test rand 1 */
  i = rand();

  RAND_init();
  RAND_add(buf,256,0.0);
  RAND_add(&i,sizeof(i),sizeof(i));
  RAND_bytes(buf,128);

  printf("/* random buffer for aiconf encryption */\n");
  printf("unsigned char ai_rand_salt[128] = {\n");
  for(j=0;j<128;j++){
    printf("0x%.2x,",buf[j]);
    if((j%16)==15) printf("\n");
  }
  printf("};\n");
  RAND_cleanup();
  return 0;
}
