#include "config.h"

#include <string.h>

#ifndef HAVE_GETPROGNAME
const char *getprogname(void);
void setprogname(const char *progname);

const char *_progname;

/**
 * Get the name of the current program
 *
 * This function returns the name of the current program.
 *
 * @returns pointer to the current program name.
 *
 */
const char *getprogname(void)
{
	return _progname;
}

/**
 * Set the name of the current program
 *
 * This function sets the name of the current program.
 *
 * @param[in] progname the path of the current program
 *
 */
void setprogname(const char *progname)
{
	_progname = strrchr(progname, '/');
	if (_progname == NULL) {
		_progname = progname;
	} else {
		_progname++;
	}
}
#endif	/* ! HAVE_GETPROGNAME */
