/* getfpath.c - get the path to a file. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/**
 * Return the path to a file.
 *
 * Do not forget to free the pointer that receives a return
 * from get_fpath().
 */
char *get_fpath(char *path, char *filename) {
	size_t fn_len = strlen(filename);
	size_t path_len = strlen(path);
	size_t total_len; /* total length including a delimiter and nul. */
	char *ret;

	/*
	 * we estimate that the total length is less than 128.
	 *   PATH + "/" + FILENAME + \0
	 */
	total_len = path_len + 1 + fn_len + 1;
	if (total_len > 128) {
		printf("ERROR: PATH+FILENAME too long.\n");
		return NULL;
	}
	/* allocate a memory to a buffer. */
	ret = (char *)malloc(total_len);
	if (ret == NULL) {
		printf("ERROR: enough memory allocation failed.\n");
	} else {
		strcpy(ret, path);
		strcat(ret, "/");
		strcat(ret, filename);
	}
	return ret;
}
