/* afi_utils.h - utility for Address Family Indepedent */
/*
 * Copyright (c) 2012-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#ifndef INCLUSION_GUARD_UUID_F367C34D_2A4B_4BFC_AE6B_8E4A3DF23CCB
#define INCLUSION_GUARD_UUID_F367C34D_2A4B_4BFC_AE6B_8E4A3DF23CCB

#ifdef  __cplusplus
extern "C" {
#endif

#define ISIPV6ADDR_TRUE  1
#define ISIPV6ADDR_FALSE 0
int isipv6addr(char *addr);

#define CONF_NORMALIZE_HOST_PARSE_SUCCESS  0
#define CONF_NORMALIZE_HOST_PARSE_FAILURE -1
#define CONF_NORMALIZE_HOST_ENOMEM        -2
int conf_normalize_host(char *host);

#define PARSE_URL_PARSE_SUCCESS  0
#define PARSE_URL_PARSE_FAILURE -1
#define PARSE_URL_ENOMEM        -2
#define PARSE_URL_ERANGE_HOST   -3
#define PARSE_URL_ERANGE_PATH   -4
#define PARSE_URL_SSL_ENABLE     1
#define PARSE_URL_SSL_DISABLE    0
int parse_url(const char *url, char *host, size_t host_len, int *port,
              char *path, size_t path_len, int *ssl);

#ifdef  __cplusplus
}
#endif

#endif	/* INCLUSION_GUARD_UUID_F367C34D_2A4B_4BFC_AE6B_8E4A3DF23CCB */
