/*
 * Copyright (c) 2004-2012 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * this is extracted from the source "aiconf.c?rev=906".
 */

#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_err.h>
#include "ok_caerr.h"
#include "ok_aica.h"	/* AccList */

/*-----------------------------------------------
	AccList alloc & free
-------------------------------------------------*/
AccList *AccList_new()
{
	AccList *ret;
	if ((ret = (AccList *)malloc(sizeof(AccList))) == NULL) {
		OK_set_error(ERR_ST_MEMALLOC, ERR_LC_CONF, ERR_PT_CONF+8, NULL);
		return NULL;
	}
	memset(ret, 0, sizeof(AccList));
	return ret;
}

void AccList_free(AccList *acc)
{
	free(acc);
}

void AccList_free_all(AccList *acc)
{
	AccList *next;
	while (acc) {
		next = acc->next;
		AccList_free(acc);
		acc = next;
	}
}
