#include <stdarg.h>
#include <stdio.h>
#include <string.h>

/**
 * set a path.
 *
 * all of the variable arguments must be character string, except
 * the last parameter that must be NULL.
 * @retval  0 success
 * @retval -1 failure
 * @retval  1 
 */
#ifndef DELIM
#define DELIM	"/"
#endif
int set_path(char *path, const size_t sz_max, ...)
{
	va_list ap;
	size_t va_len_total = 0;
	char *s;
	int rt = 0;
	path[0] = '\0';

	va_start(ap, sz_max);

	s = va_arg(ap, char *);
	if (s == NULL) {
		fprintf(stderr, "warning: no string appended.\n");
		rt = 1;
		goto end;
	}
	do {
		va_len_total += strlen(s);
		if (va_len_total >= sz_max) {
			fprintf(stderr, "<...>%s: path too long\n", s);
			rt = -1;
			goto end;
		}
		strcat(path, s);
		s = va_arg(ap, char *);
	} while (s != NULL);
end:
	va_end(ap);

	return rt;
}
