#include <CUnit/CUnit.h>
int set_path(char *path, const size_t sz_max, ...);
#define BUF_SIZE 16

void test_set_path(void)
{
	char buf[BUF_SIZE] = "";
	CU_ASSERT(0 == set_path(buf, BUF_SIZE, "/test", NULL));
	CU_ASSERT(-1 == set_path(buf, BUF_SIZE, "0123456789abcdef", NULL));
	CU_ASSERT(1 == set_path(buf, BUF_SIZE, NULL));

	set_path(buf, BUF_SIZE, "/path", "/", "file", ".ext", NULL);
	CU_ASSERT_STRING_EQUAL(buf, "/path/file.ext");
}
