/* prof_tmpl.c */
/*
 * Copyright (c) 2004-2015 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_err.h>
#include <aicrypto/ok_asn1.h>

#include "ok_caerr.h"
#include "ok_ca.h"

/*-----------------------------------------
  set certificate template
-----------------------------------------*/
int Prof_cert_settmpl(CA *ca, char *name){
	CertProf *cpf;
	char path[256];

	if((cpf=ca->cprof)==NULL) goto error;

	if(get_tmpl_path(path,216)) goto error;
	strncat(path,name,32);
	strcat(path,".cpi");

	if(cpf->der) free(cpf->der);
	if((cpf->der=ASN1_read_der(path))==NULL) goto error;

	if(ASN1_ctprof_info(ca,cpf->der)) goto error;

	return 0;
error:
	return -1;
}

/*-----------------------------------------
  set crl template
-----------------------------------------*/
int Prof_crl_settmpl(CA *ca, char *name){
	CRLProf *cpf;
	char path[256];

	if((cpf=ca->lprof)==NULL) goto error;

	if(get_tmpl_path(path,216)) goto error;
	strncat(path,name,32);
	strcat(path,".lpi");

	if(cpf->der) free(cpf->der);
	if((cpf->der=ASN1_read_der(path))==NULL) goto error;

	if(ASN1_clprof_info(ca,cpf->der)) goto error;

	return 0;
error:
	return -1;
}

/*-----------------------------------------
  get template path
-----------------------------------------*/
int get_tmpl_path(char *buf,int max){
	/* XXX: need to check overflow more carefully */
	snprintf(buf, max - sizeof("/templates/profile/"),
		 "%s/templates/profile/", DATADIR);

	return 0;
}

/*-------------------------------------------
  set subject template from certificate DN
-------------------------------------------*/
int Prof_set_sbjtmpl(CertDN *org,CertDN *dst){
	int i,j,k;

	for(i=j=0;i<org->num;i++,j++){
		k = org->rdn[i].tagoid;
		if((k==OBJ_DIR_CN)||(k==OBJ_DIR_UID)||(k==OBJ_DIR_EMAIL)){ j--; continue; }
			
		if ((dst->rdn[j].tag = strdup(org->rdn[i].tag)) == NULL){
			OK_set_error(ERR_ST_STRDUP,ERR_LC_PROF,ERR_PT_PFTMPL+3,NULL);
			return -1;
		}
		dst->rdn[j].derform = org->rdn[i].derform;
		dst->rdn[j].tagoid  = k;
	}
	dst->num = j;

	return 0;
}


