/* prof.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_err.h>

#include "ok_caerr.h"
#include "ok_ca.h"

/*-----------------------------------------
  alloc & free certificate profile
-----------------------------------------*/
CertProf *Prof_cert_new(CA *ca,char *name){
	CertProf *ret;

	if((ret=(CertProf*)malloc(sizeof(CertProf)))==NULL){
		OK_set_error(ERR_ST_MEMALLOC,ERR_LC_PROF,ERR_PT_PROF,NULL);
		goto error;
	}
	memset(ret,0,sizeof(CertProf));

	ret->pCA = ca;
	if ((ret->name = strdup(name)) == NULL){
		OK_set_error(ERR_ST_STRDUP,ERR_LC_PROF,ERR_PT_PROF,NULL);
		goto error;
	}

	return ret;
error:
	Prof_cert_free(ret);
	return NULL;
}

void Prof_cert_free(CertProf *cpf){
	if(cpf==NULL) return;

	if(cpf->name) free(cpf->name);
	if(cpf->der) free(cpf->der);

	if(cpf->fp) fclose(cpf->fp);
	if(cpf->kfp) fclose(cpf->kfp);

	cert_dn_free(&cpf->sbj_tmpl);
	CertExt_free_all(cpf->ext);
	CertStat_free_all(cpf->stat);

	free(cpf);
}

void Prof_cert_free_all(CertProf *top){
	CertProf *cp;
	while(top){
		cp = top->next;
		Prof_cert_free(top);
		top = cp;
	}
}

/*-----------------------------------------
  alloc & free crl profile
-----------------------------------------*/
CRLProf *Prof_crl_new(CA *ca,char *name){
	CRLProf *ret;

	if((ret=(CRLProf*)malloc(sizeof(CRLProf)))==NULL){
		OK_set_error(ERR_ST_MEMALLOC,ERR_LC_PROF,ERR_PT_PROF+2,NULL);
		goto error;
	}
	memset(ret,0,sizeof(CRLProf));

	ret->pCA = ca;
	if ((ret->name = strdup(name)) == NULL){
		OK_set_error(ERR_ST_STRDUP,ERR_LC_PROF,ERR_PT_PROF+2,NULL);
		goto error;
	}

	return ret;
error:
	Prof_crl_free(ret);
	return NULL;
}

void Prof_crl_free(CRLProf *cpf){
	if(cpf==NULL) return;

	if(cpf->name) free(cpf->name);
	if(cpf->der) free(cpf->der);

	CertExt_free_all(cpf->ext);

	free(cpf);
}

void Prof_crl_free_all(CRLProf *top){
	CRLProf *cp;
	while(top){
		cp = top->next;
		Prof_crl_free(top);
		top = cp;
	}
}

/*-----------------------------------------
  alloc & free csr profile
-----------------------------------------*/
CSRProf *Prof_csr_new(CA *ca){
	CSRProf *ret;

	if((ret=(CSRProf*)malloc(sizeof(CSRProf)))==NULL){
		OK_set_error(ERR_ST_MEMALLOC,ERR_LC_PROF,ERR_PT_PROF+3,NULL);
		goto error;
	}
	memset(ret,0,sizeof(CSRProf));

	ret->pCA = ca;
	ret->ca_name = ca->ca_name;

	return ret;
error:
	Prof_csr_free(ret);
	return NULL;
}

void Prof_csr_free(CSRProf *rpf){
	if(rpf==NULL) return;

	if(rpf->der) free(rpf->der);
	if(rpf->fp) fclose(rpf->fp);

	CertStat_free_all(rpf->stat);
	free(rpf);
}

void Prof_csr_free_all(CSRProf *top){
	CSRProf *cp;
	while(top){
		cp = top->next;
		Prof_csr_free(top);
		top = cp;
	}
}

