/* aicad_net.c */
/*
 * Copyright (c) 2004-2016 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <signal.h>

#include <aicrypto/ok_err.h>
#include <aicrypto/ok_asn1.h>

#include "ok_caerr.h"
#include "ok_ca.h"
#include "ok_lcmp.h"

/*-------------------------------------------------
  read LCMP message from socket 
-------------------------------------------------*/
int LCMP_read(LCMP *lc){
	unsigned char buf[16],*der=NULL;
	int i,j,k,ok=-1;

	if(lc->sock==NULL){ /* socket must be set */
		OK_set_error(ERR_ST_NULLPOINTER,ERR_LC_LCMP,ERR_PT_LCMPNET,NULL);
		goto done;	  
	}
	
	/* read DER header */
	if((i=SSL_read(lc->sock,buf,5))<5) goto done;

	if(*buf != 0x30){ /* must be ASN1 SEQUENCE */
		OK_set_error(ERR_ST_BADFORMAT,ERR_LC_LCMP,ERR_PT_LCMPNET,NULL);
		goto done;
	}
	if(ASN1_skip_(buf,&i)==NULL) goto done;

	if((der=(unsigned char*)malloc(i+2))==NULL){
		OK_set_error(ERR_ST_MEMALLOC,ERR_LC_LCMP,ERR_PT_LCMPNET,NULL);
		goto done;	  
	}
	memset(der,0,i+2);

	/* read DER full body */
	memcpy(der,buf,5); j=5;
	while(j<i){
		if((k=SSL_read(lc->sock,&der[j],i-j))<=0) goto done;
		j+=k;
	}
	ok=0;

	/* decoding DER message */
	if((lc->op=ASN1_LCMP_msg(der))==NULL) goto done;
	lc->messageId = lc->op->messageId;
	
	ok=j;
done:
	if(der) free(der);
	return ok;
}

/*-----------------------------------------
  write LCMP message to socket
-----------------------------------------*/
int LCMP_write(LCMP *lc){
	int i,j,k,ok=-1;

	if((lc->op==NULL)||(lc->sock==NULL)){ /* socket & operation must be set */
		OK_set_error(ERR_ST_NULLPOINTER,ERR_LC_LCMP,ERR_PT_LCMPNET+1,NULL);
		goto done;	  
	}

	lc->op->messageId = lc->messageId;
	if(lc->op->der==NULL){
		if((lc->op->der=LCMP_op_toDER(lc->op,NULL,&i))==NULL) goto done;
	}else{
		ASN1_skip_(lc->op->der,&i);
	}

	/* write DER message */
	j=0;
	while(j<i){
		if((k=SSL_write(lc->sock,&lc->op->der[j],i-j))<0) goto done;
		j+=k;
	}
	
	ok=j;
done:
	return ok;
}

/*-----------------------------------------
  write LCMP message to socket
-----------------------------------------*/
char *LCMP_msg2str(int msg){
	char *ret=NULL;
	switch(msg){
	case LCMP_SUCCESS:           ret="Success"; break;
	case LCMP_OPERATION_ERR:     ret="Operation Error"; break;
	case LCMP_PROTOCOL_ERR:      ret="Protocol Error"; break;
	case LCMP_UNSUPPORTED_CTRL:  ret="Unsupported Control"; break;
	case LCMP_UNSUPPORTED_OP:    ret="Unsupported Operation"; break;
	case LCMP_AUTH_ERR:          ret="Authentication Error"; break;
	case LCMP_UNSUPPORTED_AUTH:  ret="Unsupported Authentication"; break;
	case LCMP_PERMISSION_DENY:   ret="Permission Denied"; break;
	case LCMP_BAD_PROFILE:       ret="Bad Profile Name"; break;
	case LCMP_BAD_SUBJECTNAME:   ret="Bad Subject Name"; break;
	case LCMP_BAD_SERIALNUMBER:  ret="Bad Serial Number"; break;
	case LCMP_BAD_EXTENSION:     ret="Bad Extension"; break;
	case LCMP_BAD_USERNAME:      ret="Bad User Name"; break;
	case LCMP_BAD_OLDPASSWD:     ret="Bad Old Password"; break;
	case LCMP_BAD_UPDTIMING:     ret="Bad Update Timing"; break;
	case LCMP_BAD_REVOCATION:    ret="Bad Revocation"; break;
	case LCMP_BAD_PUBLICKEY:     ret="Bad Public Key"; break;
	case LCMP_NOSUCH_PROFILE:    ret="No Such Profile"; break;
	case LCMP_NOSUCH_SUBJECT:    ret="No Such Subject"; break;
	case LCMP_NOSUCH_SERIALNUM:  ret="No Such Serial Number"; break;
	case LCMP_NOSUCH_EXTENSION:  ret="No Such Extension"; break;
	case LCMP_NOSUCH_TEMPLATE:   ret="No Such Template"; break;
	case LCMP_NOSUCH_USERNAME:   ret="No Such User Name"; break;
	case LCMP_REQEST_ACCEPTED:   ret="Request Accepted"; break;
	case LCMP_REQEST_REJECTED:   ret="Request Rejected"; break;
	case LCMP_REQEST_BADACCID:   ret="Bad AcceptID Number"; break;
	case LCMP_REQEST_OPDONE:     ret="Operation Already Done"; break;
	case LCMP_REQEST_BADCSR:     ret="Bad CSR Format"; break;
	case LCMP_KEY_UNMATCHED:     ret="Unmatched Key"; break;
	case LCMP_KEY_BADPASSWD:     ret="Bad Access Password"; break;
	case LCMP_KEY_NOTEXIST:      ret="Key Is NOT Stored"; break;
	case LCMP_KEY_EXIST:         ret="Key Is Already Stored"; break;
	case LCMP_KEY_UNSUPPORTED:   ret="Unsupported Key Algorithm"; break;
	case LCMP_LICENSE_EXCEEDED:  ret="License Exceeded"; break;
	default: ret="unknown"; break;
	}
	return ret;
}
