/* ca_err.c */
/*
 * Copyright (c) 2004-2017 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download.
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <aicrypto/ok_err.h>

#include "ok_caerr.h"
#include "ok_ca.h"

/*-----------------------------------------
  CA get error string
-----------------------------------------*/
char *ca_get_err_location(int err){
	static char buf[64],tmp[16];
	int loc,point = err>>8;

	loc  = err & 0xff;
	*buf = 0;

	switch(loc){
	case ERR_LC_CA:
		strcat(buf,"CA:");
		switch(point&0xf0){
		case ERR_PT_CA: strcat(buf,"CA"); break;
		case ERR_PT_CACRL: strcat(buf,"CACRL"); break;
		case ERR_PT_CAFILE: strcat(buf,"CAFILE"); break;
		case ERR_PT_CAASN1: strcat(buf,"CAASN1"); break;
		case ERR_PT_CALCERTS: strcat(buf,"CALCERTS"); break;
		case ERR_PT_CANEW: strcat(buf,"CANEW"); break;
		case ERR_PT_CAPRINT: strcat(buf,"CAPRINT"); break;
		case ERR_PT_CASIGN: strcat(buf,"CASIGN"); break;
		case ERR_PT_CATOOL: strcat(buf,"CATOOL"); break;
		case ERR_PT_CACONF: strcat(buf,"CACONF"); break;
		case ERR_PT_CAPOL: strcat(buf,"CAPOL"); break;
		case ERR_PT_CAOP: strcat(buf,"CAOP"); break;
		case ERR_PT_CABIND: strcat(buf,"CABIND"); break;
		case ERR_PT_CAPROF: strcat(buf,"CAPROF"); break;
		}
		sprintf(tmp,"(%d)",point&0xf);
		strcat(buf,tmp);
		break;

	case ERR_LC_PROF:
		strcat(buf,"PROF:");
		switch(point&0xf0){
		case ERR_PT_PROF:  strcat(buf,"PROF"); break;
		case ERR_PT_PFTMPL:strcat(buf,"PFTMPL"); break;
		case ERR_PT_PFASN1:strcat(buf,"PFASN1"); break;
		case ERR_PT_PFFILE:strcat(buf,"PFFILE"); break;
		case ERR_PT_PFTOOL:strcat(buf,"PFTOOL"); break;
		case ERR_PT_PFCONV:strcat(buf,"PFCONV"); break;
		}
		sprintf(tmp,"(%d)",point&0xf);
		strcat(buf,tmp);
		break;

	case ERR_LC_REQ:
		strcat(buf,"REQ:");
		switch(point&0xf0){
		case ERR_PT_REQ: strcat(buf,"REQ"); break;
		}
		sprintf(tmp,"(%d)",point&0xf);
		strcat(buf,tmp);
		break;

	case ERR_LC_CONF:
		strcat(buf,"CONF:");
		switch(point&0xf0){
		case ERR_PT_CONF: strcat(buf,"CONF"); break;
		}
		sprintf(tmp,"(%d)",point&0xf);
		strcat(buf,tmp);
		break;

	case ERR_LC_LCMP:
		strcat(buf,"LCMP:");
		switch(point&0xf0){
		case ERR_PT_LCMP: strcat(buf,"LCMP"); break;
		case ERR_PT_LCMPASE: strcat(buf,"LCMP ASN1 ENC"); break;
		case ERR_PT_LCMPASD: strcat(buf,"LCMP ASN1 DEC"); break;
		case ERR_PT_LCMPNET: strcat(buf,"LCMP NET"); break;
		case ERR_PT_LCMPTOOL: strcat(buf,"LCMP TOOL"); break;
		case ERR_PT_LCMPAPI: strcat(buf,"LCMP API"); break;
		}
		sprintf(tmp,"(%d)",point&0xf);
		strcat(buf,tmp);
		break;

	case ERR_LC_CAD:
		strcat(buf,"CAD:");
		switch(point&0xf0){
		case ERR_PT_CAD:    strcat(buf,"CAD"); break;
		case ERR_PT_CADCA:  strcat(buf,"CA"); break;
		case ERR_PT_CADOP:  strcat(buf,"OP"); break;
		case ERR_PT_CADAUTH:strcat(buf,"AUTH"); break;
		}
		sprintf(tmp,"(%d)",point&0xf);
		strcat(buf,tmp);
		break;

	case ERR_LC_RAD:
		strcat(buf,"RAD:");
		switch(point&0xf0){
		case ERR_PT_RAD:    strcat(buf,"RAD"); break;
		case ERR_PT_RADRA:  strcat(buf,"RA"); break;
		case ERR_PT_RADOP:  strcat(buf,"OP"); break;
		case ERR_PT_RADUSER:strcat(buf,"USER"); break;
		case ERR_PT_RADMAIL:strcat(buf,"MAIL"); break;
		case ERR_PT_RADLDAP:strcat(buf,"LDAP"); break;
		}
		sprintf(tmp,"(%d)",point&0xf);
		strcat(buf,tmp);
		break;

	case ERR_LC_AUTH:
		strcat(buf,"AUTH:");
		switch(point&0xf0){
		case ERR_PT_AUTH: strcat(buf,"AUTH"); break;
		}
		sprintf(tmp,"(%d)",point&0xf);
		strcat(buf,tmp);
		break;

	case ERR_LC_CRLP:
		strcat(buf,"CRLP:");
		switch(point&0xf0){
		case ERR_PT_CRLP: strcat(buf,"CRLP"); break;
		case ERR_PT_CRLPCONF: strcat(buf,"CONF"); break;
		case ERR_PT_CRLPOP: strcat(buf,"OP"); break;
		case ERR_PT_CRLLDAP: strcat(buf,"LDAP"); break;
		}
		sprintf(tmp,"(%d)",point&0xf);
		strcat(buf,tmp);
		break;
		
	case ERR_LC_WEBE:
		strcat(buf,"WEBENROLL:");
		switch(point&0xf0){
		case ERR_PT_WEBE: strcat(buf,"WEBE"); break;
		case ERR_PT_WEBMAIL: strcat(buf,"WEBMAIL"); break;
		case ERR_PT_WEBLDAP: strcat(buf,"WEBLDAP"); break;
		}
		sprintf(tmp,"(%d)",point&0xf);
		strcat(buf,tmp);
		break;

	case ERR_LC_ENR:
		strcat(buf,"ENROLL:");
		switch(point&0xf0){
		case ERR_PT_ENR: strcat(buf,"ENR"); break;
		}
		sprintf(tmp,"(%d)",point&0xf);
		strcat(buf,tmp);
		break;

	case ERR_LC_AICA:
		strcat(buf,"AICA:");
		switch(point&0xf0){
		case  ERR_PT_AICA:       strcat(buf,"AICA"); break;
		case  ERR_PT_AICABIND:   strcat(buf,"BIND"); break;
		case  ERR_PT_AICACONF:   strcat(buf,"CONF"); break;
		case  ERR_PT_AICALCRT:   strcat(buf,"LCERT"); break;
		case  ERR_PT_AICANEW:    strcat(buf,"NEW"); break;
		case  ERR_PT_AICANEWSSL: strcat(buf,"NEWSSL"); break;
		case  ERR_PT_AICAOP:     strcat(buf,"OP"); break;
		case  ERR_PT_AICAPOL:    strcat(buf,"POL"); break;
		case  ERR_PT_AICAPROF:   strcat(buf,"PROF"); break;
		case  ERR_PT_AICASETEXT: strcat(buf,"SETEXT"); break;
		case  ERR_PT_AICASIGN:   strcat(buf,"SIGN"); break;
		case  ERR_PT_AICAUSER:   strcat(buf,"USER"); break;
		}
		sprintf(tmp,"(%d)",point&0xf);
		strcat(buf,tmp);
		break;

	default:
		strcat(buf,get_err_location(err));
		break;
	}
	return buf;
}

char *ca_get_err_type(int err){
	char *ret;
	switch(err){
	case ERR_ST_CA_NOCSTAT: ret="no such cert status"; break;
	case ERR_ST_CA_NORSTAT: ret="no such req status"; break;
	case ERR_ST_CA_NOEXT: ret="no such extensions"; break;
	case ERR_ST_CA_NOPROF: ret="no such profile name"; break;
	case ERR_ST_CA_BADCONF: ret="bad config file"; break;
	case ERR_ST_CA_BADCSV: ret="bad csv file"; break;
	case ERR_ST_CA_BADSN: ret="bad serial number"; break;
	case ERR_ST_CA_BADSUBJECT: ret="bad subject name"; break;
	case ERR_ST_CA_CTREVOKED: ret="a certificate was revoked"; break;
	case ERR_ST_CA_CTEXPIRED: ret="a certificate was expired"; break;
	case ERR_ST_CA_NOTINUPD: ret="not in update period"; break;
	case ERR_ST_CA_CANCELED: ret="operation is canceled"; break;
	case ERR_ST_CA_POLMIS: ret="cert subject is unmatched with CA policy"; break;
	case ERR_ST_INVALIDRSP: ret="received invalid response"; break;
	case ERR_ST_LDAPINIT: ret="ldap initialize error, connection faild"; break;
	case ERR_ST_LDAPBIND: ret="ldap bind error"; break;
	case ERR_ST_LDAPMODIFY: ret="cannot modify ldap entry"; break;
	case ERR_ST_LDAPSEARCH: ret="ldap search error"; break;
	case ERR_ST_LDAPNOENT: ret="returned no entry"; break;
	case ERR_ST_LDAPNOVAL: ret="returned no value"; break;
	case ERR_ST_SMTPSTART: ret="cannot start smtp"; break;
	case ERR_ST_SMTPHELO: ret="smtp HELO error"; break;
	case ERR_ST_SMTPFROM: ret="smtp FROM error"; break;
	case ERR_ST_SMTPRCPT: ret="smtp RCPT error"; break;
	case ERR_ST_SMTPDATA: ret="smtp DATA error"; break;
	case ERR_ST_SMTPMBODY: ret="smtp mail body send error"; break;
	default: ret=get_err_type(err); break;
	}
	return ret;
}

char *CA_get_errstr(){
	static char buf[256];
	uint32_t errnum = OK_get_error();
	CK_RV *rv_p = OK_get_errorinfo();

	sprintf(buf,"[aica] error:0x%x:%s:%s",
		errnum,
		ca_get_err_location(errnum>>16),
		ca_get_err_type(errnum&0xffff));

	if (rv_p != NULL) {
		char tmp[128];
		/* XXX:should display the Cryptoki function like C_Decrypt() */
		snprintf(tmp, sizeof(tmp) - 1,
			 "; [cryptoki] CK_RV = 0x%.8lx", *rv_p); 
		strcat(buf, tmp);
	}

	return buf;
}
