/* test64.c */
/*
 * Copyrightc 2004-2006 National Institute of Informatics in Japan, 
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/index.html.
 * If you redistribute this file, with or without modifications, you must 
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>

#include "ok_asn1.h"
#include "ok_base64.h"
#include "ok_pem.h"
#include "ok_md5.h"
#include "ok_rsa.h"
#include "ok_x509.h"
#include "ok_pkcs.h"

extern Cert *PEM_read_cert(char *fname);
extern CRL  *PEM_read_crl(char *fname);
Prvkey_RSA *PEM_read_rsaprv(char *fname);
Prvkey_RSA *ASN1_read_rsaprv(unsigned char *in);

void p12_keybag_test(char *keyf,unsigned char *p8,int *ret_len){
  P12_KeyBag	*bag;
  int		i,j,k;

  bag = P12_Key_new();
  P12_set_KeyBag(bag,(Key*)PEM_read_rsaprv(keyf),"test",1);

  P12_get_DER_keybag(bag,p8,ret_len);
  ASN1_print(p8,&j);
  printf(" -- %d\n",*ret_len);
}

void p12_certbag_test(char *caf,char *certf,unsigned char *p7enc,int *ret_len){
  unsigned char buf[3072],*cp;
  P12_CertBag	*cert,*ca;
  Cert	*ct;
  int	i,j,len;

  cert = P12_Cert_new();
  P12_set_CertBag(cert,PEM_read_cert(certf),"testCert",1);
  ca = P12_Cert_new();
  P12_set_CertBag(ca,PEM_read_cert(caf),"testCA",0);

  P12_get_DER_certbag(cert,buf,&i);
  cp = buf+i;
  P12_get_DER_certbag(ca,cp,&j);
  cp+=j; i+=j;
  ASN1_set_sequence(i,buf,&i);

  ASN1_print(buf,&j);
  printf(" -- %d\n",i);

  P7_get_DER_encrypted(i,buf,OBJ_P12Pbe_40RC2,p7enc,ret_len);
/*  cp = P7_get_decrypted(p7enc,&j);*/

  ASN1_print(p7enc,&j);
  printf(" -- %d\n",*ret_len);
}


void p12_authsafe(char *caf,char *certf,char *keyf){
  unsigned char safe[4096],p8[1024],*cp;
  int	i,j;

  p12_certbag_test(caf,certf,safe,&i);
  cp = safe+i;

  p12_keybag_test(keyf,p8,&j);
  P7_get_DER_data(j,p8,cp,&j);
  i+=j;
  
  ASN1_set_sequence(i,safe,&i);

  ASN1_print(safe,&j);
  printf(" -- %d\n",i);
}

void p12_auth_safe(char *caf,char *certf,char *keyf){
  unsigned char safe[4096],p8[1024],*cp;
  int	i,j;

  p12_certbag_test(caf,certf,safe,&i);
  cp = safe+i;

  p12_keybag_test(keyf,p8,&j);
  P7_get_DER_data(j,p8,cp,&j);
  i+=j;
  
  ASN1_set_sequence(i,safe,&i);

  ASN1_print(safe,&j);
  printf(" -- %d\n",i);
}


void p7_test(char *certf){
  unsigned char buf[1024],*cp;
  Cert  *ct;
  int   i,j,len;

  ct  = PEM_read_cert(certf);
  cp = ct->der;
  len = ASN1_length((++cp),&i);
  len += i+1;

  P7_get_DER_data(len,ct->der,buf,&i);
  ASN1_print(buf,&j);
  printf(" -- %d\n",i);
}

void p8_test(char *keyf){
  unsigned char buf[1024],*ret;
  Prvkey_RSA	*key;
  int		i,j,k;

  key = PEM_read_rsaprv(keyf);
  P8_get_DER_encrypted((Key*)key,OBJ_P12Pbe_3K3DES,buf,&i);
  ASN1_print(buf,&j);
  printf(" -- %d,%d\n",i,j);
/*
for(k=0;k<i;k++) printf("%.2x ",buf[k]);
printf(" -- %d,%d\n",i,j);
*/
  ret = P8_get_decrypted(buf,&i);
/*
  ASN1_print(ret,&j);

for(k=0;k<i;k++) printf("%.2x ",ret[k]);
printf(" -- %d,%d\n",i);
*/
  AIFREE(ret);
  Key_free((Key*)key);
}




void p12_make(PKCS12 *p12,char *caf,char *certf,char *keyf){
  P12_CertBag	*cert,*ca;
  P12_KeyBag	*key;

  cert = P12_Cert_new();
  P12_set_CertBag(cert,PEM_read_cert(certf),"testCert",1);
  if(cert->cert) P12_add_bag(p12,(P12_Baggage*)cert);

  ca = P12_Cert_new();
  P12_set_CertBag(ca,PEM_read_cert(caf),"testCA",0);
  if(ca->cert) P12_add_bag(p12,(P12_Baggage*)ca);

  key = P12_Key_new();
  P12_set_KeyBag(key,(Key*)PEM_read_rsaprv(keyf),"test",1);
  if(key->key) P12_add_bag(p12,(P12_Baggage*)key);
}




int main(int argc,char **argv){
  unsigned char buf[1024];
  int	i,j;
  PKCS12 *p12;
/*
  Cert	*ct;
  ct  = PEM_read_cert(argv[1]);
  Cert_get_DER_subject(&(ct->subject_dir),buf,&i);
for(j=0;j<i;j++) printf("%.2x ",buf[j]);
printf(" -- %d\n",i);
  ASN1_print(buf,&i);
  p7_test(argv[1]);
*/

  p12 = P12_new();
  p12_make(p12,argv[1],argv[2],argv[3]);
/*
  p12 = P12_read_file(argv[1]);
*/
  P12_write_file(p12,"test.p12");
/*
  P12_DER_authsafe(p12,safe,&i);
printf(" --- ORG --- ORG --- ORG --- \n");
  P12_print(p12);
printf(" --- ORG --- ORG --- ORG --- \n");

  P12_free(p12);
  p12 = P12_new();

  P12_authsafe(p12,safe);
  P12_print(p12);
*/
}
