/*
 * Copyright (c) 2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#include <stdlib.h>
#include <string.h>
#include "ok_conf.h"	/* CONF_PATH_MAX */

extern char ctstore[];	/* path to "store_dir" */

/**
 * Read configuration of certificate store.
 */
int store_config(char *fname)
{
	char *buf = NULL;
	int err = -1;

	buf = conf_get_section(fname, "[general info]", NULL);
	if (buf == NULL)
		goto done;

	err = conf_getstr(buf, "store_dir", ctstore, CONF_PATH_MAX - 2);
	/* XXX: note that conf_getstr() always returns 0. */
done:
	if (buf != NULL)
		free(buf);
	return err;
}
