/* certreq_tool.c */
/*
 * Copyright (c) 2004-2016 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#ifdef KEKGRIDCA
#include <netdb.h>
#include <sys/socket.h>
#include <sys/types.h>
#endif
#include <aicrypto/ok_asn1.h>
#include <aicrypto/ok_x509.h>
#ifdef KEKGRIDCA
#include <aicrypto/ok_ssl.h>
#include <aicrypto/ok_err.h>
#include <aicrypto/ok_base64.h>
#endif
#include "certreq.h"

#ifndef AICONFIG
#define AICONFIG "aica.cnf"
#endif

/*
extern int f_idpw;
extern int f_noint;
extern int f_chpin;
 */
extern int f_noint;
extern int f_simple_ou;
extern char userid[];
extern char group[];
extern char sgl[];
#ifdef KEKGRIDCA
//extern char uid[];
extern char userpw[];
extern char fqdn[];
extern char service[];
extern char name[];
extern int f_hcert;
extern int f_lcert;
extern int f_rcert;
extern int f_withhostslash;
#endif

extern char ou[];
extern char cn[];
extern char email[];

extern char def_grp[];
extern char def_ou[];
extern char def_cn[];
extern char def_em[];

#ifdef KEKGRIDCA
#define SSL_HOST "rra01.kek.jp"
#define PATH_CN "/regist/aiusercn.php"
#define PATH_OU "/regist/aiuserou.php"
#define SSL_SERVICE "https"
#endif
int get_rdn_by_https(int rdn, char *rdn_value);

char *input_simple_subject(CertDN *dn, int f_idpw, int f_chpin){
	char buf[32],tmp[128],*ret=NULL;
	int i,inp=1,usem;

	memset(buf,0,32);
	if(*cn==0){
		memset(cn,0,128);
		strncpy(cn,def_cn,126);
	}
	if(*email==0){
		memset(email,0,128);
		if(f_noint) strcpy(email,".");
		strncpy(email,def_em,126);
	}
	if(*ou==0){
		memset(ou,0,128);
		strncpy(ou,def_ou,126);
	}
	if(*group==0){
		strncpy(group,def_grp,30);
	}
	if(f_idpw) strncpy(cn,userid,126);
	if(f_chpin){ strcpy(cn,"."); strcpy(email,"."); inp=0; } /* set dummy */

	/* subject input */
	while(inp){
		printf("\n------- input %s subject information --------\n",
		       (*sgl)?(sgl):("user"));
		printf("* email can be omitted by putting a char of '.'\n\n");
		usem = 1;

		while(*group == 0){
			printf("input group : ");
			fgets(group,30,stdin);
			i=strlen(group); group[i-1]=0; /* clean return code */
		}

		while(*ou == 0 && f_simple_ou){
			printf("input ou : ");
			fgets(ou,126,stdin);
			i=strlen(ou); ou[i-1]=0; /* clean return code */
		}

		strncpy(tmp,cn,126);
		while(*tmp == 0){
			*cn = 0;
			printf("input %s name  : ",(*sgl)?(sgl):("user"));
			fgets(tmp,126,stdin);
			i=strlen(tmp); tmp[i-1]=0; /* clean return code */

			if(*sgl){
			  strncpy(cn,sgl,30);
			  strcat(cn,"/");
			}
			strncat(cn,tmp,96);
		}

		while(*email == 0){
			printf("input %s email : ",(*sgl)?(sgl):("user"));
			fgets(email,126,stdin);
			i=strlen(email); email[i-1]=0; /* clean return code */
		}

		if(!strcmp(email,".")) usem = 0;

		if(!f_chpin){
			printf("\n------- please confirm your inputs ------------\n");
			if (!strcmp(group,"NONE_NEEDED")) { /* REQ_OP_CSR */
				printf("SUBJECT : ");
			} else {
				printf("GROUP   : %s\nSUBJECT : ",group);
			}
			if(f_simple_ou) printf("OU=%s, ",ou);
			printf("CN=%s",cn);
			if(usem) printf(", Email=%s",email);
			printf("\n\n");
		}
		if(!f_noint){
			printf("do you continue operation? (yes/no/retry)[y]:");
			fgets(buf,30,stdin);
			switch(*buf){
			case 'r':
			case 'R':
				printf("'retry' was selected. please input again.\n");
				*group=*ou=*cn=*email=0;
				continue;
			case 'n':
			case 'N':
				printf("operation canceled.\n");
				return NULL;
			}
		}
		break; /* default break */
	}

	dn->num = i = 0;
	if(f_simple_ou){
		if ((dn->rdn[i].tag = strdup(ou)) == NULL) goto done;
		dn->rdn[i].tagoid	= OBJ_DIR_OU;
		dn->rdn[i].derform = asn1_str_type(ou);
		dn->num++; i++;
	}

	if ((dn->rdn[i].tag = strdup(cn)) == NULL) goto done;
	dn->rdn[i].tagoid	= OBJ_DIR_CN;
	dn->rdn[i].derform = asn1_str_type(cn);
	dn->num++; i++;

	if(usem){
		if ((dn->rdn[i].tag = strdup(email)) == NULL) goto done;
		dn->rdn[i].tagoid	= OBJ_DIR_EMAIL;
		dn->rdn[i].derform = ASN1_IA5STRING;
		dn->num++;
	}

	ret = Cert_subject_str(dn);
done:	
	return ret;
}

#ifdef KEKGRIDCA
char *input_simple_subjectk(CertDN *dn){
	char buf[32],tmp[128],*ret=NULL;
	int i,inp=0,usem,rc;

	memset(buf,0,32);
	if(*cn==0){
		memset(cn,0,128);
		strncpy(cn,def_cn,126);
	}
	if(*email==0){
		memset(email,0,128);
		if(f_noint) strcpy(email,".");
		strncpy(email,def_em,126);
	}
	if(*group==0){
		strncpy(group,def_grp,30);
	}

	printf("%s is now trying to login...", userid);

	/* get CN */
	memset(tmp,0,128);
	rc=get_rdn_by_https(0, tmp);
	if (rc != 0){
		printf("Failed to get CN.\n");
		printf("CLI abort.\n");
		exit(rc);
	} else{
		strcpy(cn,tmp);
	}

	/* get 2nd OU */
	memset(tmp,0,128);
	rc=get_rdn_by_https(1, tmp);
	if (rc != 0){
		printf("Failed to get OU.\n");
		printf("CLI abort.\n");
		exit(rc);
	} else{
		strcpy(ou,tmp);
	}

	if((dn->rdn[0].tag=strdup("JP"))==NULL) goto done;
	dn->rdn[0].tagoid	= OBJ_DIR_C;
	dn->rdn[0].derform = asn1_str_type("JP");
	dn->num = 1;

	if((dn->rdn[1].tag=strdup("KEK"))==NULL) goto done;
	dn->rdn[1].tagoid	= OBJ_DIR_O;
	dn->rdn[1].derform = asn1_str_type("KEK");
	dn->num = 2;

	if((dn->rdn[2].tag=strdup("CRC"))==NULL) goto done;
	dn->rdn[2].tagoid	= OBJ_DIR_OU;
	dn->rdn[2].derform = asn1_str_type("CRC");
	dn->num = 3;

	if(*ou){
		if((dn->rdn[3].tag=strdup(ou))==NULL) goto done;
		dn->rdn[3].tagoid	= OBJ_DIR_OU;
		dn->rdn[3].derform = asn1_str_type(ou);
		dn->num++;
		if((dn->rdn[4].tag=strdup(cn))==NULL) goto done;
		dn->rdn[4].tagoid	= OBJ_DIR_CN;
		dn->rdn[4].derform = ASN1_IA5STRING;
		dn->num++;
	} else {
		if((dn->rdn[3].tag=strdup(cn))==NULL) goto done;
		dn->rdn[3].tagoid	= OBJ_DIR_CN;
		dn->rdn[3].derform = ASN1_IA5STRING;
		dn->num++;
	}

	ret = Cert_subject_str(dn);
done:
	return ret;
}

char *input_simple_subjecth(CertDN *dn){
	char buf[32],tmp[128],*ret=NULL;
	int i,inp=0,rc,usem;

	memset(buf,0,32);
	if(*cn==0){
		memset(cn,0,128);
		strncpy(cn,def_cn,126);
	}
	if(*email==0){
		memset(email,0,128);
		if(f_noint) strcpy(email,".");
		strncpy(email,def_em,126);
	}
	if(*group==0){
		strncpy(group,def_grp,30);
	}
	if(*fqdn==0){
		memset(fqdn,0,256);
		strncpy(cn,def_cn,254);
	}

	if ( f_hcert ) {;
		if ( f_withhostslash ) {
			strcpy(tmp,"host/");
		}
		else {
			strcpy(tmp,"");
		}
	} else if ( f_lcert) {
		strcpy(tmp,"ldap/");
        } else if ( f_rcert) {
                strcpy(tmp,"Robot: ");
	}
        if ( f_hcert || f_lcert ) {
	strcat(tmp,fqdn);
        }
        else if(f_rcert){
        strcat(tmp,service);
        strcat(tmp," - ");
        }
        if ( f_rcert) {
             /* rc=get_rdn_by_https(0, buf);
                if (rc != 0){
                   printf("Failed to get CN.\n");
                   printf("CLI abort.\n");
                   exit(rc);
                }
                strcat(tmp,buf);
             */
             strcat(tmp,name);
        } 
	strcpy(cn,tmp);

	if((dn->rdn[0].tag=strdup("JP"))==NULL) goto done;
	dn->rdn[0].tagoid	= OBJ_DIR_C;
	dn->rdn[0].derform = asn1_str_type("JP");
	dn->num = 1;

	if((dn->rdn[1].tag=strdup("KEK"))==NULL) goto done;
	dn->rdn[1].tagoid	= OBJ_DIR_O;
	dn->rdn[1].derform = asn1_str_type("KEK");
	dn->num = 2;

	if((dn->rdn[2].tag=strdup("CRC"))==NULL) goto done;
	dn->rdn[2].tagoid	= OBJ_DIR_OU;
	dn->rdn[2].derform = asn1_str_type("CRC");
	dn->num = 3;

	if(*ou){
		if((dn->rdn[3].tag=strdup(ou))==NULL) goto done;
		dn->rdn[3].tagoid	= OBJ_DIR_OU;
		dn->rdn[3].derform = asn1_str_type(ou);
		dn->num++;
		if((dn->rdn[4].tag=strdup(cn))==NULL) goto done;
		dn->rdn[4].tagoid	= OBJ_DIR_CN;
		dn->rdn[4].derform = ASN1_IA5STRING;
		dn->num++;
	} else {
		if((dn->rdn[3].tag=strdup(cn))==NULL) goto done;
		dn->rdn[3].tagoid	= OBJ_DIR_CN;
		dn->rdn[3].derform = ASN1_IA5STRING;
		dn->num++;
	}

	ret = Cert_subject_str(dn);
done:
	return ret;
}
#endif

int input_simple_subject2(Req *req){
	char buf[32];
	int i;

	/* subject input */
	for(;;){
		printf("\n------- input %s subject information --------\n",
		       (*sgl)?(sgl):("user"));

		while(*group == 0){
			printf("input group : ");
			fgets(group,30,stdin);
			i=strlen(group); group[i-1]=0; /* clean return code */
		}

		printf("\n------- please confirm your inputs ------------\n");
		printf("group : %s\n%s\n\n",group,req->subject);

		printf("do you continue operation? (yes/no/retry)[y]:");
		fgets(buf,30,stdin);
		switch(*buf){
		case 'r':
		case 'R':
			printf("'retry' was selected. please input again.\n");
			*group = 0;
			continue;
		case 'n':
		case 'N':
			printf("operation canceled.\n");
			return -1;
		}

		break; /* default break */
	}

	return 0;
}

int req_ask_onoff(char *txt,int on){
	char buf[128] = "";
	int ret = 1;

	for(;;){
		printf("%s (on/off)[%s]: ",txt,(on)?("on"):("off"));
		fgets(buf,64,stdin);

		if(strstr(buf,"on")){ ret=1; break; }
		if(strstr(buf,"off")){ ret=0; break; }
		if((*buf==0)||(*buf=='\n')){ ret=on; break; }

		printf("Invalid operation! Please input again.\n");
	}
	return ret;
}

int req_ask_yesno(char *txt,int yes){
	char buf[128] = "";
	int ret = 1;
	
	for(;;){
		printf("%s (y/n)[%s]: ",txt,(yes)?("y"):("n"));
		fgets(buf,64,stdin);
		
		if(strstr(buf,"y")){ ret=1; break; }
		if(strstr(buf,"n")){ ret=0; break; }
		if((*buf==0)||(*buf=='\n')){ ret=yes; break; }
		
		printf("Invalid operation! Please input again.\n");
	}
	return ret;
}

int req_ask_num(char *txt,int num){
	char buf[128] = "";
	int ret = num;

	printf("%s [%d]: ",txt,num);
	fgets(buf,64,stdin);

	if((*buf==0)||(*buf=='\n')) ret=num;
	else ret=atoi(buf);

	return ret;
}

int req_ask_comment(char *txt,char *buf, int max){
	char *cp;
	printf("%s : ",txt);
	fgets(buf,max,stdin);
	if((cp=strchr(buf,'\n')) != NULL) *cp=0;
	return 0;
}

/**
 *  * Expand string like regular expresions and assign them to a matrix.
 *   *
 *    * @param[out] argv The two-dimentional array to put the expanded into.
 *     * @param[in]  s    The source string like regular expression.
 *      * @return          The number of expanded strings.
 *       */
enum {
	MISSING_LEFT_PARENTHESIS   = -1,
	MISSING_DELIMITER	   = -2,
	MISSING_RIGHT_PARENTHESIS  = -3,
	AND_THEN_THERE_WERE_NONE   = -4,
	TOO_MUCH_LEFT_PARENTHESIS  = -5,
	TOO_MUCH_RIGHT_PARENTHESIS = -6
};
int expand_str(char argv[FQDN_MAX][FQDN_LEN_MAX], const char *s)
{
	char  f_str[FQDN_LEN_MAX * 2];
	char  h_str[FQDN_LEN_MAX * 2];
	char middle[FQDN_LEN_MAX * 2];
	char    tmp[FQDN_LEN_MAX * 2];
	char *p, *q;
	int idx = 0;
	size_t len = 0;
	bool all_strings_are_null = true;
	bool just_one_null_exists = false;

	if ((p = strchr(s, '(')) == NULL) {
		idx = MISSING_LEFT_PARENTHESIS;
		if (strchr(s, '|') == NULL) {
			if (strchr(s, ')') == NULL) {
				/* maybe, the input has a normal expression. */
				idx = 0;
				goto end;
			} else {
				/* only RIGHT_P exists. */
				goto end;
			}
		} else {
			/* LEFT_P does not exist but DELIM exists. */
			goto end;
		}
	} else {
		if ((p = strchr(p, '|')) == NULL) {
			idx = MISSING_DELIMITER;
			goto end;
		} else {
			if (strchr(p, ')') == NULL) {
				idx = MISSING_RIGHT_PARENTHESIS;
				goto end;
			}
		}
	}
	
	p = strncpy(middle, s, sizeof(middle) - 1);

	/* s --> f_str, (...)... */
	if ((p = strchr(middle, '(')) != NULL) {
		(void)strncpy(tmp, p, sizeof(tmp) - 1);
		*p = '\0';
		(void)strncpy(f_str, middle, sizeof(f_str) - 1);
	}

	/* (...)... --> middle, h_str */
	if ((p = strchr(tmp, ')')) != NULL) {
		(void)strncpy(h_str, p + 1, sizeof(h_str) - 1);
		*p = '\0';
		(void)strncpy(middle, tmp + 1, sizeof(middle) - 1);
	}

	/* currently no support for a nest of expressions. */
	if (strchr(middle, '(') != NULL) {
		idx = TOO_MUCH_LEFT_PARENTHESIS;
		goto end;
	}
	if (strchr(h_str, ')') != NULL) {
		idx = TOO_MUCH_RIGHT_PARENTHESIS;
		goto end;
	}

	len = strlen(f_str) + strlen(h_str);

	for (p = q = middle; (q != NULL) && (idx < FQDN_MAX); p = q + 1) {
		size_t sz;
		if ((q = strchr(p, '|')) != NULL)
			*q = '\0';
		if ((sz = strlen(p)) != 0) {
			all_strings_are_null = false;
		} else {
			if (just_one_null_exists)
				continue;	/* skip the second empty. */
			else
				just_one_null_exists = true;
		}
		if ((len + sz) < FQDN_LEN_MAX) {
			(void)strcpy(argv[idx], f_str);
			(void)strcat(argv[idx], p);
			(void)strcat(argv[idx], h_str);
			idx++;
		} else {
			/* XXX: how should it be handled ? */
		}
	}
	if (all_strings_are_null)
		idx = AND_THEN_THERE_WERE_NONE;
end:
	return idx;
}

#ifdef KEKGRIDCA
int get_rdn_by_https(int rdn, char *rdn_value) {
	struct addrinfo hints;
	struct addrinfo *res, *rp;
	SSL *ssl;

	char *rdn_type[2] = {"CN","OU"};

	char *host = SSL_HOST;
	char *path[2] = { PATH_CN , PATH_OU };
	char *service = SSL_SERVICE;

	int sfd = -1;
	int error = 0;
	int sslret;

	char basic_auth[128];
	char *basic_auth_base64 = NULL;

	int msg_size = 4096;
	char msg[msg_size];
	int buf_size = 512;
	char buf[buf_size];

	int read_size, nread = 0;
	char *http_status, *http_body, *content_length;
	int status, cl_header, cl_calc;

	memset(basic_auth,0,128);
	strcpy(basic_auth,userid);
	strcat(basic_auth,":");
	strcat(basic_auth,userpw);

	memset(msg,0,msg_size);
	memset(buf,0,buf_size);

	/* get addrinfo list */
	memset(&hints, 0, sizeof(hints));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;

	error = getaddrinfo(host, service, &hints, &res);
	if (error != 0) {
		printf("error: getaddrinfo: %s for host %s service %s\n",
			gai_strerror(error), host, service);
		exit(EXIT_FAILURE);
	}

	for (rp = res; rp != NULL; rp = rp->ai_next) {
		sfd = socket(rp->ai_family, rp->ai_socktype, rp->ai_protocol);
		if (sfd == -1) {
			continue;
		}
		if (connect(sfd, rp->ai_addr, rp->ai_addrlen) != -1) {
			break; /* Success */
		}
	}

	if (rp == NULL) {
		printf("error: could not connect to %s\n", host);
		exit(EXIT_FAILURE);
	}

	/* new SSL */
	ssl = SSL_new();
	if (ssl == NULL){
		printf("error: SSL_new().\n");
		exit(EXIT_FAILURE);
	}

	/* don't verify server certificate */
	SSL_set_vfytype(ssl, SSL_DONT_VERIFY);

	sslret = SSL_set_fd(ssl,sfd);
	if (sslret == 0) {
		printf("error: SSL_set_fd().\n");
		exit(EXIT_FAILURE);
	}
	sslret = SSL_handshake(ssl);
	if (sslret != 0) {
		printf("error: SSL_handshake(). code=%d\n",sslret);
		exit(EXIT_FAILURE);
	}

	/* Basic authentication */
	basic_auth_base64 = Base64_encode(strlen(basic_auth), (unsigned char *)basic_auth, 16);

	if (rdn == 0 || rdn == 1) {
		sprintf(msg, "GET %s HTTP/1.1\r\nAuthorization: Basic %s\r\nUser-Agent: naregi-ca/3.0 \r\nHost: %s\r\nAccept: */*\r\n\r\n", path[rdn], basic_auth_base64, host);
	} else {
		printf("CLI abort.\n");
		return(-1);
	}

	/* Send message */
	sslret = SSL_write(ssl,msg,strlen(msg));
	if (sslret < 0){;
		printf("error: SSL_write().\n");
		exit(EXIT_FAILURE);
	}

	/* Receive message */
	do {
		read_size=SSL_read(ssl,buf,buf_size);
		if (read_size > 0){
			if (nread + read_size < msg_size){
				memcpy(&msg[nread],buf,read_size);
				nread += read_size;
			}else{
				printf("error: http response is too large.\n");
				printf("CLI abort.\n");
				return(-1);
			}
		}else if(read_size < 0){
			printf("error : SSL_read().\n");
			exit(EXIT_FAILURE);
		}
	} while(read_size > 0);

	msg[nread] = '\0';

	http_status=strstr(msg,"HTTP/");
	if (http_status != NULL){
		http_status+=8;
	}else{
		printf("invalid http response.\n");
		printf("CLI abort.\n");
		exit(EXIT_FAILURE);
	}
	status=atoi(http_status);
	if (status == 0){
		printf("invalid http response.\n");
		printf("CLI abort.\n");
		exit(EXIT_FAILURE);
	}else if(status == 401){
                if(f_rcert){//printf("userid (%s) or password may be wrong.\n", uid);
                }else{
		printf("userid (%s) or password may be wrong.\n", userid);
                }
		printf("CLI abort.\n");
		exit(EXIT_FAILURE);
	}else if(status >= 300){
		printf("KEK Grid CA System serivice seems to be unavailable.\n");
   		printf("CLI abort.\n");
		exit(EXIT_FAILURE);
	}

	http_body=strstr(msg,"\r\n\r\n");
	if (http_body != NULL){
		http_body+=4;
	}else{
		printf("invalid http response.\n");
		printf("error: CLI abort.\n");
		exit(EXIT_FAILURE);
	}

	content_length=strstr(msg,"Content-Length:");
	if (content_length != NULL){
		content_length+=15;
	}else{
		printf("invalid http response.\n");
		printf("CLI abort.\n");
		exit(EXIT_FAILURE);
	}

	cl_header=atoi(content_length);
	cl_calc=nread-(http_body-msg);
	if (cl_header == cl_calc){
		if (cl_header > 128){
			printf("invalid http response.\n");
			printf("CLI abort.\n");
			exit(EXIT_FAILURE);
		}else if(cl_header > 0){
			printf("%d bytes retrieved as %s\n", cl_header, rdn_type[rdn]);
			strncpy(rdn_value,http_body,(size_t)cl_header);
		}
	}else{
		printf("cannot retreive %s\n", rdn_type[rdn]);
		printf("CLI abort.\n");
		exit(EXIT_FAILURE);
	}

	sslret = SSL_shutdown(ssl,2);
#if 0
	if (sslret < 0){
		printf("error: SSL_shutdown().\n");
		exit(EXIT_FAILURE);
	}
#endif
	SSL_close(ssl);
	SSL_free(ssl);

	freeaddrinfo(res);

	return(0);
}
#endif
