/* certreq_conf.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_tool.h>

#include "ok_conf.h"

#ifndef AICONFIG
#define AICONFIG "aica.cnf"
#endif

/* general info */
char svpath[256] = "";
char caname[32]  = "";
char ctstore[CONF_PATH_MAX]  = "";

char clp12f[256] = "";
char certid[32]  = "";
#define DEFAULT_USERID	"dummy"
char userid[64]  = DEFAULT_USERID;
char userpw[PWD_BUFLEN*2] = "";

char def_grp[64] = "";
char def_em[128] = "";
char def_cn[128] = "";
char def_ou[128] = "";

#define DEFAULT_CAPORT	11412
int caport = DEFAULT_CAPORT;
int usessl = 0;
int vfycert= 0;

/* store_conf.c */
int store_config(char *fname);

/* req.c */
int req_config(char *fname, int num);

/* functions */
int req_set_config(char *buf);

int req_read_config(char *fname){
	char *buf = NULL;
	int err=-1;

	/* get store information */
	if (store_config(fname)) {
		printf("cannot find \"store_dir\" in the file:\n%s\n", fname);
		goto done;
	}

	/* set default subject information */
	if(req_config(fname,0)) goto done;

	/* get certreq information */
	if((buf=conf_get_section(fname,"[certreq]","[certreq end]"))==NULL) goto done;
	conf_clear_comment(buf);

	err = req_set_config(buf);
done:
	if(buf) free(buf);
	return err;
}

int req_set_config(char *buf){
	int v1=0,v2=0;

	if (svpath[0] == '\0') {
		/* not specified with the command-line option '-sv' */
		if (conf_getstr(buf, "ca_dir", svpath, 254)) goto error;
	}
	if (strcmp(userid, DEFAULT_USERID) == 0) {
		/* with '-user' */
		if (conf_getstr(buf, "ca_uid", userid, 30)) goto error;
	}
	if (userpw[0] == '\0') {
		/* with '-pw' */
		if (conf_getstr(buf, "ca_pwd", userpw, PWD_BUFLEN)) goto error;
	}
	if (caport == DEFAULT_CAPORT) {
		/* of course, the value of ca_port in aica.cnf may equal
		 * to DEFAULT_CAPORT
		 */
		if(conf_getint(buf, "ca_port", &caport)) goto error;
	}

	if (usessl == 0) {
		/* it will become 1 if the following options are specified:
		 * '-ssl', '-cl', '-clid', '-clcer', and '-clkey'
		 */
		if (conf_getbool(buf, "f_ssl_use", &usessl)) goto error;
	}
	if(conf_getbool(buf,"f_ssl_novfy",&v1)) goto error;
	if(conf_getbool(buf,"f_ssl_novfycrl",&v2)) goto error;

	if(v2) vfycert = IF_NO_CRL_DONT_CHECK_REVOKED | DONT_VERIFY_CRL;
	if(v1) vfycert = DONT_VERIFY;

	if (certid[0] == '\0') {
		/* with '-clid' */
		if (conf_getstr(buf, "cl_id", certid, 32)) goto error;
	}
	if (userpw[0] == '\0') {
		/* FIXME: not userpw but clctpw?
		 */
		if (conf_getstr(buf, "cl_id_pwd", userpw, PWD_BUFLEN)) goto error;
	}

	/* the followings do not overwrite the values specified
	 * with the command-line options such as '-g', '-cn', and '-em'.
	 */
	if(conf_getstr(buf,"default_group",def_grp,62)) goto error;
	if(conf_getstr(buf,"default_cn",def_cn,126)) goto error;
	if(conf_getstr(buf,"default_em",def_em,126)) goto error;

	return 0;
error:
	return -1;
}
