/*
 * Copyright (c) 2014-2016 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */

#ifndef INCLUSION_GUARD_UUID_1C040503_E49E_4C73_A3A2_881502569283
#define INCLUSION_GUARD_UUID_1C040503_E49E_4C73_A3A2_881502569283

/**
 * define login mode (f_login) to access an RA server.
 */
#define CERTREQ_LOGIN_NONE      0 /* anonymous */
#define CERTREQ_LOGIN_IDPW      1 /* use ID/Password */
#define CERTREQ_LOGIN_LICE      2 /* use LicenseID */
#define CERTREQ_LOGIN_CHPN      4 /* use challenge PIN */

/**
 * Support for mulitiple subjectAltNames (dnsName).
 */
#define FQDN_MAX	8
#define FQDN_LEN_MAX	256
/**
 *
 */
int expand_str(char [][FQDN_LEN_MAX], const char *);

/**
 * define an enumeration type for certreq(1) operations.
 */
enum req_op {
	REQ_OP_CSR,
	REQ_OP_ISSUE,
	REQ_OP_REVOKE,
	REQ_OP_RENEW,
	REQ_OP_RECEIVE,
	REQ_OP_REKEY,
	REQ_OP_HELP = -1,
	REQ_OP_UNKNOWN = -2,
};

#endif	/* INCLUSION_GUARD_UUID_1C040503_E49E_4C73_A3A2_881502569283 */
