/* asn1view.c */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 *  Akira Iwata Laboratory. 
 *  Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usagi@mars.elcom.nitech.ac.jp)
 * And if you want to contact us, send e-mail to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * This library is free for commercial and non-commercial use as long as
 * the following conditions are aheared to.
 * If you want to use aicrypto library and CA applications code in product,
 * should be e-mail to Akira Iwata Laboratory (wakayama@elcom...).
 * 
 * Please note that MD2 and MD5 include RSA Data Security, Inc. LICENSE.
 * Those are besed on RFC1319 and RFC1321 document. And copyright distribution
 * is following in ok_md2.h ok_md5.h .
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_asn1.h>
#include <aicrypto/ok_pem.h>

char fp[256];			/* file path */

/* functions */
void options(int argc, char *argv[]);
void usage(void);
int print_pkcs12(char *fname);

/* common/version.c */
void print_version(char *argv[]);

/*-----------------------------------------
  ASN.1 Viewer
-----------------------------------------*/
int main(int argc, char **argv)
{
	unsigned char *der;

	if (argc == 1) {
		usage();
		exit(EXIT_FAILURE);
	}

	options(argc, argv);

	if ((der = PEM_read_cert_2der(fp)) != NULL) {
		OK_ASN1_print(der);
		free(der);
	}
	if ((der = PEM_read_crl_2der(fp)) != NULL) {
		OK_ASN1_print(der);
		free(der);
	}
	if ((der = PEM_read_rsaprv_2der(fp)) != NULL) {
		OK_ASN1_print(der);
		free(der);
	}
	if ((der = PEM_read_dsaprv_2der(fp)) != NULL) {
		OK_ASN1_print(der);
		free(der);
	}
	if ((der = PEM_read_ecdsaprv_2der(fp)) != NULL) {
		OK_ASN1_print(der);
		free(der);
	}
	if ((der = PEM_read_req_2der(fp)) != NULL) {
		OK_ASN1_print(der);
		free(der);
	}
	if ((der = PEM_read_p7_2der(fp)) != NULL) {
		OK_ASN1_print(der);
		free(der);
		return 0;
	}
	if ((der = PEM_read_p8_2der(fp)) != NULL) {
		OK_ASN1_print(der);
		free(der);
		return 0;
	}
	if ((der = PEM_read_p8enc_2der(fp)) != NULL) {
		OK_ASN1_print(der);
		free(der);
		return 0;
	}

	if (print_pkcs12(fp))
		return 1;

	if ((der = ASN1_read_der(fp)) != NULL) {
		OK_ASN1_print(der);
		free(der);
	}
	return 0;
}

/*-----------------------------------------
  check option and print usage
-----------------------------------------*/
void options(int argc, char *argv[])
{
	int i;

	for (i = 1; i < argc; i++) {
		if (!strcmp("-help", argv[i])) {
			usage();
			exit(EXIT_SUCCESS);
		} else if (!strcmp("-version", argv[i])) {
			print_version(argv);
			exit(EXIT_SUCCESS);
		} else {
			if (argv[i][0] == '-') {
				printf("option error!\n");
				printf("unknown option: `%s'\n", argv[i]);
				usage();
				exit(EXIT_FAILURE);
			}
		}
		strncpy(fp, argv[i], 254);
	}
}

void usage(void)
{
	printf("\
Usage: asn1view [OPTION] FILE\n\
\n\
FILE is a file in PEM or DER or PKCS#12 format.\n\
\n\
Options:\n\
  -help		print this message\n\
  -version	print version information and exit\n\
");
}
