/* aireadpw.c - read a password via a controlling terminal */
/*
 * Copyright (c) 2004-2014 National Institute of Informatics in Japan,
 * All rights reserved.
 *
 * This file or a portion of this file is licensed under the terms of
 * the NAREGI Public License, found at http://www.naregi.org/download/
 * If you redistribute this file, with or without modifications, you must
 * include this notice in the file.
 */
/*
 * Copyright (C) 1998-2004
 * Akira Iwata & Takuto Okuno
 * Akira Iwata Laboratory,
 * Nagoya Institute of Technology in Japan.
 *
 * All rights reserved.
 *
 * This software is written by Takuto Okuno(usapato@anet.ne.jp)
 * And if you want to contact us, send an email to Kimitake Wakayama
 * (wakayama@elcom.nitech.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software must
 *    display the following acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *    Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Akira Iwata Laboratory,
 *     Nagoya Institute of Technology in Japan (http://mars.elcom.nitech.ac.jp/)."
 *
 *   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *   AKIRA IWATA LABORATORY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 *   SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 *   IN NO EVENT SHALL AKIRA IWATA LABORATORY BE LIABLE FOR ANY SPECIAL,
 *   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *   FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *   NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aicrypto/ok_pkcs.h>
#include <aicrypto/ok_tool.h>

enum opt_mode {
	OPT_DEFAULT,
	OPT_VERIFY,
	OPT_PKCS12,
} mode;

char pass[PWD_BUFLEN] = "";
char file[256] = "";
char prompt[64] = "Input Password : ";

void options(int argc, char **argv);
void usage(void);

/* common/version.c */
void print_version(char *argv[]);

int main(int argc, char *argv[])
{
	char buf[PWD_BUFLEN + 2];

	mode = OPT_DEFAULT;
	options(argc, argv);

	memset(buf, 0, PWD_BUFLEN + 2);
	if (pass[0] != '\0') {
		OK_set_passwd(pass);
	}

	if (mode == OPT_VERIFY) {
		do {
			OK_get_passwd(prompt, buf, M_VRFY);
		} while (buf[0] == '\0');
	} else if (mode == OPT_PKCS12) {
		PKCS12 *p12;

		OK_set_passwd(buf);
		if ((p12 = P12_read_file(file)) == NULL)
			strcpy(buf, "error");
		else
			strcpy(buf, "ok");

		OK_clear_passwd();
		P12_free(p12);
	} else {
		do {
			OK_get_passwd(prompt, buf, M_NOVRFY);
		} while (buf[0] == '\0');
	}

	printf("%s", buf);

	memset(buf, 0, PWD_BUFLEN);
	OK_clear_passwd();

	return EXIT_SUCCESS;
}

void options(int argc, char **argv)
{
	int i;

	for (i = 1; i < argc; i++) {
		if (!strcmp("-help", argv[i])) {
			usage();
			exit(EXIT_SUCCESS);
		} else if (!strcmp("-version", argv[i])) {
			print_version(argv);
			exit(EXIT_SUCCESS);
		} else if (!strcmp("-pr", argv[i])) {
			i++;
			if (i < argc)
				strncpy(prompt, argv[i], sizeof(prompt) - 2);
		} else if (!strcmp("-p12", argv[i])) {
			i++;
			mode = OPT_PKCS12;
			if (i < argc)
				strncpy(file, argv[i], sizeof(file) - 2);
		} else if (!strcmp("-p", argv[i])) {
			i++;
			if (i < argc)
				strncpy(pass, argv[i], PWD_BUFLEN);
		} else if (!strcmp("-v", argv[i])) {
			mode = OPT_VERIFY;
		} else if (argv[i][0] == '-') {
			printf("unknown option: `%s'\n", argv[i]);
			usage();
			exit(EXIT_FAILURE);
		}
	}
}

void usage(void)
{
	printf("\
Usage: aireadpw [OPTION...]\n\
\n\
Options:\n\
  -help		print this message\n\
");
 /* currently do not know the following option...
  -p12 FILE  \n\
  */
	printf("\
  -p STRING	set password\n\
  -pr STRING	set prompt message\n\
  -v		verify the password input\n\
  -version	print version information and exit\n\
");
}
