/* wincrytestfc.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ok_rsa.h"
#include "ok_asn1.h"
#include "ok_x509.h"
#include "ok_pem.h"
#include "ok_tool.h"
#include "ok_wincry.h"

int test_wincry_cert(){
	Cert *ct;
	if((ct=Cert_read_file("test.cer"))==NULL){
		printf("test_wincry_cert : cannot open cert file.\n");
		return -1;}

	if(Cert_add_toStore(ct,WIN_STORE_MY)){
		printf("test_wincry_cert : cannot add cert to the system store.\n");
		return -1;}

	if(Cert_del_fromStore(ct,WIN_STORE_MY)){
		printf("test_wincry_cert : cannot delete cert to the system store.\n");
		return -1;}

	printf("test_wincry_cert : scceeded to add & del with the system store.\n");
	Cert_free(ct);
	return 0;
}

int test_wincry_key(){
	Cert *ct;
	Prvkey_RSA *prv;

	if((ct=Cert_read_file("test.cer"))==NULL){
		printf("test_wincry_key : cannot open cert file.\n");
		return -1;
	}

	OK_set_passwd("abcde");
	if((prv=PEM_read_rsaprv("test.key"))==NULL){
		printf("test_wincry_key : cannot open RSAprv file.\n");
		return -1;
	}
	OK_clear_passwd();

	if(Cert_add_toMyStore(ct,(Key*)prv,0,1)){
		printf("test_wincry_key : cannot add private key to MY store.\n");
		return -1;
	}
	printf("test_wincry_key : scceeded to add cert & private key into the system store.\n");
	Key_free((Key*)prv);

	if((prv=(Prvkey_RSA*)Cert_get_keyFromContainer(ct))==NULL){
		printf("test_wincry_key : cannot get private key from MY store.\n");
		return -1;
	}

	printf("test_wincry_key : scceeded to get private key from the system store.\n");
	Key_free((Key*)prv);
	Cert_free(ct);

	return 0;
}

int test_wincry_crl(){
	CRL *crl;
	if((crl=CRL_read_file("test.crl"))==NULL){
		printf("test_wincry_crl : cannot open crl file.\n");
		return -1;}

	if(CRL_add_toStore(crl,WIN_STORE_MY)<0){
		printf("test_wincry_crl : cannot add crl to the system store.\n");
		return -1;}

	if(CRL_del_fromStore(crl,WIN_STORE_MY)<0){
		printf("test_wincry_crl : cannot delete crl to the system store.\n");
		return -1;}

	printf("test_wincry_crl : scceeded to add & del with the system store.\n");
	CRL_free(crl);
	return 0;
}

int test_wincry_clist(){
	CertList *cl;

	if((cl=Certlist_get_from_system(WIN_STORE_ROOT))==NULL)
		return -1;
	Certlist_free_all(cl);
	printf("test certlist from system (root) get & free -- ok\n");

	if((cl=Certlist_get_from_system(WIN_STORE_CA))==NULL)
		return -1;
	Certlist_free_all(cl);
	printf("test certlist from system (ca) get & free -- ok\n");

	if((cl=Certlist_get_from_system(WIN_STORE_MY))==NULL)
		return -1;
	Certlist_free_all(cl);
	printf("test certlist from system (my) get & free -- ok\n");

	return 0;
}

